/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi;

public class ACPIInfo {
    private byte systemState;
    private byte deviceState;

    public static ACPIInfo fromRaw(byte[] raw) {
        if (raw.length != 2) {
            return null;
        }
        ACPIInfo acpiInfo = new ACPIInfo();
        acpiInfo.systemState = raw[0];
        acpiInfo.deviceState = raw[1];
        return acpiInfo;
    }

    public String getSystemStateInfo() {
        String state = "";
        switch (this.systemState) {
            case 0: {
                state = "S0 / G0";
                break;
            }
            case 1: {
                state = "S1";
                break;
            }
            case 2: {
                state = "S2";
                break;
            }
            case 3: {
                state = "S3";
                break;
            }
            case 4: {
                state = "S4";
                break;
            }
            case 5: {
                state = "S5 / G2";
                break;
            }
            case 6: {
                state = "S4 / S5";
                break;
            }
            case 7: {
                state = "G3";
                break;
            }
            case 8: {
                state = "sleeping";
                break;
            }
            case 9: {
                state = "G1 sleeping";
                break;
            }
            case 10: {
                state = "override";
                break;
            }
            case 32: {
                state = "Legacy On";
                break;
            }
            case 33: {
                state = "Legacy Off";
                break;
            }
            case 42: {
                state = "unknown";
                break;
            }
            default: {
                state = "undefined";
            }
        }
        return state;
    }

    public String getSystemStateDescription() {
        String desc = "";
        switch (this.systemState) {
            case 0: {
                desc = "working";
                break;
            }
            case 1: {
                desc = "hardware context maintained, typically equates to processor/chip set clocks stopped";
                break;
            }
            case 2: {
                desc = "typically equates to stopped clocks with processor/cache context lost";
                break;
            }
            case 3: {
                desc = "typically equates to \"suspend-to-RAM\"";
                break;
            }
            case 4: {
                desc = "typically equates to \"suspend-to-disk\"";
                break;
            }
            case 5: {
                desc = "soft off";
                break;
            }
            case 6: {
                desc = "soft off, cannot differentiate between S4 and S5";
                break;
            }
            case 7: {
                desc = "mechanical off";
                break;
            }
            case 8: {
                desc = "sleeping - cannot differentiate between S1-S3";
                break;
            }
            case 9: {
                desc = "sleeping - cannot differentiate between S1-S4";
                break;
            }
            case 10: {
                desc = "S5 entered by override";
                break;
            }
            case 32: {
                desc = "Legacy On (indicates On for system that don't support ACPI or have ACPI capabilities disabled)";
                break;
            }
            case 33: {
                desc = "Legacy Soft-Off";
                break;
            }
            case 42: {
                desc = "power state has not been initialized, or device lost track of power state";
                break;
            }
            default: {
                desc = "undefined";
            }
        }
        return desc;
    }

    public String getDeviceStateInfo() {
        String state = "";
        switch (this.deviceState) {
            case 0: {
                state = "D0";
                break;
            }
            case 1: {
                state = "D1";
                break;
            }
            case 2: {
                state = "D2";
                break;
            }
            case 3: {
                state = "D3";
                break;
            }
            case 42: {
                state = "unknown";
                break;
            }
            default: {
                state = "undefined";
            }
        }
        return state;
    }

    public String getDeviceStateDescription() {
        String desc = "";
        switch (this.deviceState) {
            case 0: {
                desc = "";
                break;
            }
            case 1: {
                desc = "";
                break;
            }
            case 2: {
                desc = "";
                break;
            }
            case 3: {
                desc = "";
                break;
            }
            case 42: {
                desc = "power state has not been initialized, or device lost track of power state";
                break;
            }
            default: {
                desc = "undefined";
            }
        }
        return desc;
    }

    public void setDeviceState(byte deviceState) {
        this.deviceState = deviceState;
    }

    public void setSystemState(byte systemState) {
        this.systemState = systemState;
    }

    public byte getDeviceState() {
        return this.deviceState;
    }

    public byte getSystemState() {
        return this.systemState;
    }
}

