/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi;

import com.supermicro.ipmi.ByteUtility;

public class DeviceInfo {
    public byte deviceID;
    public byte deviceRevision;
    public byte firmwareRevision1;
    public byte firmwareRevision2;
    public byte IPMIVersion;
    public byte additionalDeviceSupport;
    public byte[] manufacturerID;
    public byte[] productID;
    public byte[] auxiliaryFirmwareRevisionInfo;

    public static DeviceInfo fromRaw(byte[] raw) {
        if (raw.length < 11) {
            return null;
        }
        DeviceInfo deviceInfo = new DeviceInfo();
        int index = 0;
        deviceInfo.deviceID = raw[index];
        deviceInfo.deviceRevision = raw[++index];
        deviceInfo.firmwareRevision1 = raw[++index];
        deviceInfo.firmwareRevision2 = raw[++index];
        deviceInfo.IPMIVersion = raw[++index];
        deviceInfo.additionalDeviceSupport = raw[++index];
        deviceInfo.manufacturerID = new byte[3];
        deviceInfo.productID = new byte[3];
        deviceInfo.auxiliaryFirmwareRevisionInfo = new byte[3];
        System.arraycopy(raw, ++index, deviceInfo.manufacturerID, 0, 3);
        System.arraycopy(raw, index += 3, deviceInfo.productID, 0, 2);
        index += 2;
        if (raw.length == 15) {
            System.arraycopy(raw, index, deviceInfo.auxiliaryFirmwareRevisionInfo, 0, 3);
        }
        return deviceInfo;
    }

    public String toReadableString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Firmware Revision  = " + ByteUtility.byteToHex(this.firmwareRevision1) + "." + ByteUtility.byteToHex(this.firmwareRevision2) + "\n");
        sb.append("IPMI Version       = " + (this.IPMIVersion == 2 ? "2.0" : "Unknown") + "\n");
        sb.append("Manufacturer ID    = " + ByteUtility.bytesToHex(this.manufacturerID) + "\n");
        sb.append("product ID         = " + ByteUtility.bytesToHex(this.productID));
        return sb.toString();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Device ID = " + ByteUtility.byteToHex(this.deviceID) + "h \n");
        sb.append("Device Revision = " + ByteUtility.byteToHex(this.deviceRevision) + "h \n");
        sb.append("Firmware Revision 1 = " + ByteUtility.byteToHex(this.firmwareRevision1) + "h \n");
        sb.append("Firmware Revision 2 = " + ByteUtility.byteToHex(this.firmwareRevision2) + "h \n");
        sb.append("IPMI Version = " + ByteUtility.byteToHex(this.IPMIVersion) + "h \n");
        sb.append("Additional Device Support = " + ByteUtility.byteToHex(this.additionalDeviceSupport) + "h \n");
        sb.append("Device Revision = " + ByteUtility.byteToHex(this.deviceRevision) + "h \n");
        sb.append("Manufacturer ID = " + ByteUtility.bytesToHex(this.manufacturerID) + "h \n");
        sb.append("product ID = " + ByteUtility.bytesToHex(this.productID) + "h \n");
        sb.append("Auxiliary Firmware Revision Info = " + ByteUtility.bytesToHex(this.auxiliaryFirmwareRevisionInfo) + "h \n");
        return sb.toString();
    }

    public void setDeviceID(byte deviceID) {
        this.deviceID = deviceID;
    }

    public void setDeviceRevision(byte deviceRevision) {
        this.deviceRevision = deviceRevision;
    }

    public void setFirmwareRevision1(byte firmwareRevision1) {
        this.firmwareRevision1 = firmwareRevision1;
    }

    public void setFirmwareRevision2(byte firmwareRevision2) {
        this.firmwareRevision2 = firmwareRevision2;
    }

    public void setAdditionalDeviceSupport(byte additionalDeviceSupport) {
        this.additionalDeviceSupport = additionalDeviceSupport;
    }

    public void setManufacturerID(byte[] manufacturerID) {
        this.manufacturerID = manufacturerID;
    }

    public void setProductID(byte[] productID) {
        this.productID = productID;
    }

    public void setAuxiliaryFirmwareRevisionInfo(byte[] auxiliaryFirmwareRevisionInfo) {
        this.auxiliaryFirmwareRevisionInfo = auxiliaryFirmwareRevisionInfo;
    }

    public void setIPMIVersion(byte IPMIVersion2) {
        this.IPMIVersion = IPMIVersion2;
    }

    public byte getDeviceID() {
        return this.deviceID;
    }

    public byte getDeviceRevision() {
        return this.deviceRevision;
    }

    public byte getFirmwareRevision1() {
        return this.firmwareRevision1;
    }

    public byte getFirmwareRevision2() {
        return this.firmwareRevision2;
    }

    public byte getAdditionalDeviceSupport() {
        return this.additionalDeviceSupport;
    }

    public byte[] getManufacturerID() {
        return this.manufacturerID;
    }

    public byte[] getProductID() {
        return this.productID;
    }

    public byte[] getAuxiliaryFirmwareRevisionInfo() {
        return this.auxiliaryFirmwareRevisionInfo;
    }

    public byte getIPMIVersion() {
        return this.IPMIVersion;
    }
}

