/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.IIPMIMessage;
import com.supermicro.ipmi.IPMIInterface;
import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.IPMILanCommand;
import com.supermicro.ipmi.IPMIMessage;
import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.IPMIOEMCommand;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.SessionControllerFactory;

public class IPMB
implements IPMIInterface {
    IPMIMessagingCommand ipmiMessagingCommand;
    IPMIInterface ipmiInterface;
    private byte channel;

    public IPMB(IPMIInterface ipmiInterface) {
        this.ipmiMessagingCommand = new IPMIMessagingCommand(ipmiInterface);
    }

    public void drop(IIPMIMessage ipmiMessage) {
    }

    public void initialize(IPMIInterfaceConfig config) {
    }

    public IPMIMessage send(IIPMIMessage ipmiMessage) {
        byte[] message = ipmiMessage.raw();
        message[0] = 34;
        IPMIMessage resMessage = this.ipmiMessagingCommand.sendMessageCommand(this.channel, message);
        return resMessage;
    }

    public IPMIMessage receive() {
        return null;
    }

    public IPMIMessage sendOrg(IIPMIMessage ipmiMessage) {
        ((IPMIMessage)ipmiMessage).rqSA = (byte)32;
        ((IPMIMessage)ipmiMessage).rqSeqLun = (byte)(((IPMIMessage)ipmiMessage).rqSeqLun | 2);
        byte[] message = ipmiMessage.raw();
        message[0] = 34;
        IPMIMessage resMessage = this.ipmiMessagingCommand.sendMessageCommand(this.channel, message);
        System.out.println("Send return code:" + ByteUtility.byteToHex(resMessage.completionCode) + " Size:" + resMessage.data.length);
        if (resMessage.completionCode != 0) {
            return null;
        }
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        boolean done = false;
        int count = 0;
        do {
            IPMIMessage retMessage = this.ipmiMessagingCommand.getMessageCommand();
            System.out.println("Get return code:" + ByteUtility.byteToHex(retMessage.completionCode) + " Size:" + retMessage.data.length);
            if (retMessage != null && retMessage.completionCode == 0) {
                System.out.println(ByteUtility.bytesToHex(retMessage.data));
                boolean b = this.ipmiMessagingCommand.clearReceiveMessageQueue();
                System.out.println("clear receive message queue = " + b);
                return retMessage;
            }
            try {
                Thread.sleep(100L);
                ++count;
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
        } while (count <= 10 && !done);
        return null;
    }

    public void setChannel(byte channel) {
        this.channel = channel;
    }

    public byte getChannel() {
        return this.channel;
    }

    public static void main(String[] args) {
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setIp("192.168.1.118");
        config.setUserName("ADMIN");
        config.setPassword("ADMIN");
        config.setPrivilege((byte)4);
        IPMILanCommand ipmiLanCommand = new IPMILanCommand(null);
        IPMIOEMCommand ipmiOEMCommand = new IPMIOEMCommand(null);
        ISessionController sessionController = SessionControllerFactory.createSessionController(config, ipmiLanCommand);
        if (sessionController == null) {
            return;
        }
        IPMB ipmb = new IPMB(ipmiLanCommand.getIPMIInterface());
        ipmiLanCommand.setIPMIInterface(ipmb);
        ipmiOEMCommand.setIPMIInterface(ipmb);
        ipmb.setChannel((byte)9);
        System.out.println(ipmiLanCommand.getIP());
        System.out.println(ipmiLanCommand.getMAC());
        System.out.println(ipmiLanCommand.getGatewayIP());
        System.out.println("Sensors:" + ByteUtility.bytesToHex(ipmiOEMCommand.getSensors()));
        for (int i = 0; i < 100; ++i) {
            System.out.println("Sensors:" + ByteUtility.bytesToHex(ipmiOEMCommand.getSensors()));
        }
        boolean b = sessionController.closeSession();
    }
}

