/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.GlobalDefine;
import com.supermicro.ipmi.IPMICommand;
import com.supermicro.ipmi.IPMIInterface;
import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.IPMIMessage;
import com.supermicro.ipmi.IPMINetworkInterface;
import com.supermicro.ipmi.IPMIVersion;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.LogUtil;
import com.supermicro.ipmi.MessageCenter;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class IPMILanCommand
extends IPMICommand {
    public static final byte DHCP = 2;
    public static final byte STATIC_IP = 1;

    public IPMILanCommand(IPMIInterface ipmiInterface) {
        super(ipmiInterface);
    }

    public IPMIMessage setLanConfigurationParameterCommand(byte channelNumber, byte selector, byte[] pData) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[2 + pData.length];
        data[0] = channelNumber;
        data[1] = selector;
        System.arraycopy(pData, 0, data, 2, pData.length);
        ipmiMessage.setCommandAndData((byte)48, (byte)1, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getLanConfigurationParameterCommand(byte channelNumber, byte selector, byte setSelector, byte blockSelector) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{channelNumber, selector, setSelector, blockSelector};
        ipmiMessage.setCommandAndData((byte)48, (byte)2, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getIP_UDP_RMCP_StatisticsCommand(boolean clear) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{1, clear ? (byte)1 : 0};
        ipmiMessage.setCommandAndData((byte)48, (byte)4, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public String getIP() {
        IPMIMessage resMessage = this.getLanConfigurationParameterCommand((byte)1, (byte)3, (byte)0, (byte)0);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                String ip = "";
                ip = (resMessage.data[1] & 0xFF) + "." + (resMessage.data[2] & 0xFF) + "." + (resMessage.data[3] & 0xFF) + "." + (resMessage.data[4] & 0xFF);
                return ip;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return null;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute get LAN configuration");
        return null;
    }

    public boolean setIP(String ip) {
        byte[] data = new byte[4];
        if (!IPMILanCommand.isIPAddress(ip)) {
            MessageCenter.getInstance().put(this, (Object)"IP format error!");
            return false;
        }
        StringTokenizer st = new StringTokenizer(ip, ".");
        for (int i = 0; i < 4; ++i) {
            if (!st.hasMoreTokens()) {
                MessageCenter.getInstance().put(this, (Object)"IP format error!");
                return false;
            }
            data[i] = (byte)Integer.parseInt(st.nextToken());
        }
        IPMIMessage resMessage = this.setLanConfigurationParameterCommand((byte)1, (byte)3, data);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return true;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return false;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute set LAN configuration");
        return false;
    }

    public String getMAC() {
        IPMIMessage resMessage = this.getLanConfigurationParameterCommand((byte)1, (byte)5, (byte)0, (byte)0);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                String mac = "";
                mac = ByteUtility.byteToHex(resMessage.data[1]) + ":" + ByteUtility.byteToHex(resMessage.data[2]) + ":" + ByteUtility.byteToHex(resMessage.data[3]) + ":" + ByteUtility.byteToHex(resMessage.data[4]) + ":" + ByteUtility.byteToHex(resMessage.data[5]) + ":" + ByteUtility.byteToHex(resMessage.data[6]);
                return mac;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return null;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute get LAN configuration");
        return null;
    }

    public boolean setMAC(String mac) {
        byte[] data = new byte[6];
        if (!IPMILanCommand.isMacAddress(mac)) {
            MessageCenter.getInstance().put(this, (Object)"MAC format error!");
            return false;
        }
        StringTokenizer st = new StringTokenizer(mac, ":");
        for (int i = 0; i < 6; ++i) {
            if (!st.hasMoreTokens()) {
                MessageCenter.getInstance().put(this, (Object)"MAC format error!");
                return false;
            }
            data[i] = (byte)(Integer.parseInt(st.nextToken(), 16) & 0xFF);
        }
        IPMIMessage resMessage = this.setLanConfigurationParameterCommand((byte)1, (byte)5, data);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return true;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return false;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute set LAN configuration");
        return false;
    }

    public String getSubnetMask() {
        IPMIMessage resMessage = this.getLanConfigurationParameterCommand((byte)1, (byte)6, (byte)0, (byte)0);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                String mask = "";
                mask = (resMessage.data[1] & 0xFF) + "." + (resMessage.data[2] & 0xFF) + "." + (resMessage.data[3] & 0xFF) + "." + (resMessage.data[4] & 0xFF);
                return mask;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return null;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute get LAN configuration");
        return null;
    }

    public boolean setSubnetMask(String mask) {
        byte[] data = new byte[4];
        if (!IPMILanCommand.isIPAddress(mask)) {
            MessageCenter.getInstance().put(this, (Object)"Subnet Mask format error!");
            return false;
        }
        StringTokenizer st = new StringTokenizer(mask, ".");
        for (int i = 0; i < 4; ++i) {
            if (!st.hasMoreTokens()) {
                MessageCenter.getInstance().put(this, (Object)"MASK format error!");
                return false;
            }
            data[i] = (byte)Integer.parseInt(st.nextToken());
        }
        IPMIMessage resMessage = this.setLanConfigurationParameterCommand((byte)1, (byte)6, data);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return true;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return false;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute set LAN configuration");
        return false;
    }

    public String getGatewayIP() {
        IPMIMessage resMessage = this.getLanConfigurationParameterCommand((byte)1, (byte)12, (byte)0, (byte)0);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                String gatewayIP = "";
                gatewayIP = (resMessage.data[1] & 0xFF) + "." + (resMessage.data[2] & 0xFF) + "." + (resMessage.data[3] & 0xFF) + "." + (resMessage.data[4] & 0xFF);
                return gatewayIP;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return null;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute get LAN configuration");
        return null;
    }

    public boolean setGatewayIP(String gatewayIP) {
        byte[] data = new byte[4];
        if (!IPMILanCommand.isIPAddress(gatewayIP)) {
            MessageCenter.getInstance().put(this, (Object)"Gateway IP format error!");
            return false;
        }
        StringTokenizer st = new StringTokenizer(gatewayIP, ".");
        for (int i = 0; i < 4; ++i) {
            if (!st.hasMoreTokens()) {
                MessageCenter.getInstance().put(this, (Object)"gatewayIP format error!");
                return false;
            }
            data[i] = (byte)Integer.parseInt(st.nextToken());
        }
        IPMIMessage resMessage = this.setLanConfigurationParameterCommand((byte)1, (byte)12, data);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return true;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return false;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute set LAN configuration");
        return false;
    }

    public String getGatewayMAC() {
        IPMIMessage resMessage = this.getLanConfigurationParameterCommand((byte)1, (byte)13, (byte)0, (byte)0);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                String gatewayMAC = "";
                gatewayMAC = ByteUtility.byteToHex(resMessage.data[1]) + ":" + ByteUtility.byteToHex(resMessage.data[2]) + ":" + ByteUtility.byteToHex(resMessage.data[3]) + ":" + ByteUtility.byteToHex(resMessage.data[4]) + ":" + ByteUtility.byteToHex(resMessage.data[5]) + ":" + ByteUtility.byteToHex(resMessage.data[6]);
                return gatewayMAC;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return null;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute get LAN configuration");
        return null;
    }

    public boolean setGatewayMAC(String gatewayMAC) {
        byte[] data = new byte[6];
        if (!IPMILanCommand.isMacAddress(gatewayMAC)) {
            MessageCenter.getInstance().put(this, (Object)"setGateway MAC format error!");
            return false;
        }
        StringTokenizer st = new StringTokenizer(gatewayMAC, ":");
        for (int i = 0; i < 6; ++i) {
            if (!st.hasMoreTokens()) {
                MessageCenter.getInstance().put(this, (Object)"gateway MAC format error!");
                return false;
            }
            data[i] = (byte)(Integer.parseInt(st.nextToken(), 16) & 0xFF);
        }
        IPMIMessage resMessage = this.setLanConfigurationParameterCommand((byte)1, (byte)13, data);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return true;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return false;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute set LAN configuration");
        return false;
    }

    public String getCommunityString() {
        IPMIMessage resMessage = this.getLanConfigurationParameterCommand((byte)1, (byte)16, (byte)0, (byte)0);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                byte[] data = new byte[18];
                System.arraycopy(resMessage.data, 1, data, 0, data.length);
                return new String(data).trim();
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return null;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute get LAN configuration");
        return null;
    }

    public boolean setCommunityString(String communityString) {
        byte[] data = new byte[18];
        System.arraycopy(communityString.getBytes(), 0, data, 0, communityString.getBytes().length);
        IPMIMessage resMessage = this.setLanConfigurationParameterCommand((byte)1, (byte)16, data);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return true;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return false;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute set LAN configuration");
        return false;
    }

    public int getNumberOfDestination() {
        IPMIMessage resMessage = this.getLanConfigurationParameterCommand((byte)1, (byte)17, (byte)0, (byte)0);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data[1];
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return 0;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute get LAN configuration");
        return 0;
    }

    public String getDestinationIP(byte index) {
        IPMIMessage resMessage = this.getLanConfigurationParameterCommand((byte)1, (byte)19, index, (byte)0);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                String ip = "";
                ip = (resMessage.data[4] & 0xFF) + "." + (resMessage.data[5] & 0xFF) + "." + (resMessage.data[6] & 0xFF) + "." + (resMessage.data[7] & 0xFF);
                return ip;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return null;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute get LAN configuration");
        return null;
    }

    public String getDestinationMAC(byte index) {
        IPMIMessage resMessage = this.getLanConfigurationParameterCommand((byte)1, (byte)19, index, (byte)0);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                String gatewayMAC = "";
                gatewayMAC = ByteUtility.byteToHex(resMessage.data[8]) + ":" + ByteUtility.byteToHex(resMessage.data[9]) + ":" + ByteUtility.byteToHex(resMessage.data[10]) + ":" + ByteUtility.byteToHex(resMessage.data[11]) + ":" + ByteUtility.byteToHex(resMessage.data[12]) + ":" + ByteUtility.byteToHex(resMessage.data[13]);
                return gatewayMAC;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return null;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute get LAN configuration");
        return null;
    }

    public static boolean isMacAddress(String macAddressCandidate) {
        Pattern macPattern = Pattern.compile("[0-9a-fA-F]{2}:[0-9a-fA-F]{2}:[0-9a-fA-F]{2}:[0-9a-fA-F]{2}:[0-9a-fA-F]{2}:[0-9a-fA-F]{2}");
        Matcher m = macPattern.matcher(macAddressCandidate);
        return m.matches();
    }

    public static boolean isIPAddress(String ipAddressCandidate) {
        Pattern macPattern = Pattern.compile("\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}");
        Matcher m = macPattern.matcher(ipAddressCandidate);
        return m.matches();
    }

    public boolean setDesitnationIPandMAC(byte index, String ip, String mac) {
        byte[] data = new byte[13];
        byte[] ipBytes = new byte[4];
        StringTokenizer st = new StringTokenizer(ip, ".");
        for (int i = 0; i < 4; ++i) {
            if (!st.hasMoreTokens()) {
                MessageCenter.getInstance().put(this, (Object)"IP format error!");
                return false;
            }
            ipBytes[i] = (byte)Integer.parseInt(st.nextToken());
        }
        byte[] macBytes = new byte[6];
        st = new StringTokenizer(mac, ":");
        for (int i = 0; i < 6; ++i) {
            if (!st.hasMoreTokens()) {
                MessageCenter.getInstance().put(this, (Object)"MAC format error!");
                return false;
            }
            macBytes[i] = (byte)(Integer.parseInt(st.nextToken(), 16) & 0xFF);
        }
        data[0] = index;
        data[1] = 0;
        data[2] = 0;
        System.arraycopy(ipBytes, 0, data, 3, 4);
        System.arraycopy(macBytes, 0, data, 7, 6);
        IPMIMessage resMessage = this.setLanConfigurationParameterCommand((byte)1, (byte)19, data);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return true;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return false;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute set LAN configuration");
        return false;
    }

    public boolean setDefaultPEFDestinationType(byte destinationSelector) {
        byte[] data = new byte[]{destinationSelector, 0, 0, 0};
        IPMIMessage resMessage = this.setLanConfigurationParameterCommand((byte)1, (byte)18, data);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return true;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return false;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute set LAN configuration");
        return false;
    }

    public byte getLanSettingType() {
        IPMIMessage resMessage = this.getLanConfigurationParameterCommand((byte)1, (byte)4, (byte)0, (byte)0);
        if (resMessage != null && resMessage.completionCode == 0) {
            return resMessage.data[1];
        }
        return 0;
    }

    public boolean setLanSettingType(byte type) {
        byte[] data = new byte[]{type};
        IPMIMessage resMessage = this.setLanConfigurationParameterCommand((byte)1, (byte)4, data);
        return resMessage != null && resMessage.completionCode == 0;
    }

    public byte getBMCGeneratedARP() {
        byte[] data = new byte[]{};
        IPMIMessage resMessage = this.getLanConfigurationParameterCommand((byte)1, (byte)11, (byte)0, (byte)0);
        if (resMessage != null && resMessage.completionCode == 0) {
            return resMessage.data[1];
        }
        return 0;
    }

    public boolean setBMCGeneratedARP(boolean isEnable) {
        byte[] data = new byte[]{this.getBMCGeneratedARP()};
        data[0] = isEnable ? (byte)(data[0] | 1) : (byte)(data[0] & 0xFFFFFFFE);
        IPMIMessage resMessage = this.setLanConfigurationParameterCommand((byte)1, (byte)11, data);
        return resMessage != null && resMessage.completionCode == 0;
    }

    public static void main(String[] args) {
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setIp("192.168.10.240");
        config.setUserName("ADMIN");
        config.setPassword("ADMIN");
        config.setPrivilege((byte)4);
        ISessionController sessionController = IPMIVersion.getSessionController(config);
        IPMILanCommand ipmiLanCommand = new IPMILanCommand(null);
        int count = 0;
        while (true) {
            IPMINetworkInterface rmcp;
            if ((rmcp = sessionController.startup(config)) != null) {
                LogUtil.printLog("(" + count++ + ") Login:OK");
                ipmiLanCommand.setIPMIInterface(rmcp);
                System.out.println(ipmiLanCommand.getCommunityString());
                boolean result = sessionController.closeSession();
                if (result) {
                    LogUtil.printLog("Logout:OK");
                } else {
                    LogUtil.printLog("Logout:Fail");
                }
            } else {
                LogUtil.printLog("Login:Fail");
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ex) {
            }
        }
    }

    public static void main_org(String[] args) {
        String communityString;
        String getwayMAC;
        String getwayIP;
        String subnetMask;
        String mac;
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setIp("192.168.10.240");
        config.setUserName("ADMIN");
        config.setPassword("ADMIN");
        config.setPrivilege((byte)4);
        ISessionController sessionController = IPMIVersion.getSessionController(config);
        IPMILanCommand ipmiLanCommand = new IPMILanCommand(null);
        IPMINetworkInterface rmcp = sessionController.startup(config);
        if (rmcp == null) {
            MessageCenter.getInstance().put("Network error");
            return;
        }
        MessageCenter.getInstance().put("RMCP Login successfully");
        ipmiLanCommand.setIPMIInterface(rmcp);
        String ip = ipmiLanCommand.getIP();
        if (ip != null) {
            MessageCenter.getInstance().put("IP = " + ip);
        }
        if ((mac = ipmiLanCommand.getMAC()) != null) {
            MessageCenter.getInstance().put("MAC = " + mac);
        }
        if ((subnetMask = ipmiLanCommand.getSubnetMask()) != null) {
            MessageCenter.getInstance().put("Subnet Mask = " + subnetMask);
        }
        if ((getwayIP = ipmiLanCommand.getGatewayIP()) != null) {
            MessageCenter.getInstance().put("Getway IP = " + getwayIP);
        }
        if ((getwayMAC = ipmiLanCommand.getGatewayMAC()) != null) {
            MessageCenter.getInstance().put("Getway MAC = " + getwayMAC);
        }
        if ((communityString = ipmiLanCommand.getCommunityString()) != null) {
            MessageCenter.getInstance().put("Community String = " + communityString);
        }
        int numberOfDestination = ipmiLanCommand.getNumberOfDestination();
        MessageCenter.getInstance().put("Number of Destination = " + numberOfDestination);
        for (int j = 0; j < numberOfDestination; ++j) {
            String dIP = ipmiLanCommand.getDestinationIP((byte)j);
            String dMAC = ipmiLanCommand.getDestinationMAC((byte)j);
            if (ip == null) continue;
            System.out.println("Destination IP address : " + dIP + ", MAC : " + dMAC);
        }
        System.out.println(ipmiLanCommand.getLanSettingType());
        sessionController.closeSession();
    }
}

