/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class LogUtil {
    private static FileWriter outs;
    public static boolean displayLog;
    public static boolean writeLog;

    public static synchronized void testLog(String msg) {
        String dir = System.getProperty("user.dir");
        dir = dir + File.separator + "log.txt";
        try {
            outs = new FileWriter(dir, true);
            outs.write("[" + LogUtil.getSystemDateTime() + "]" + msg + "\n");
            outs.close();
        }
        catch (IOException ex) {
            System.out.println("--- error to write log[" + dir + "]! ---");
        }
    }

    public static synchronized void writeLog(String msg) {
        String dir = System.getProperty("user.dir");
        dir = dir + File.separator + "log.txt";
        LogUtil.writeLog(dir, msg);
    }

    public static synchronized void printLog(String msg) {
        System.out.println("[" + LogUtil.getSystemDateTime() + "]" + msg);
    }

    public static synchronized void writeLog(String filename, String msg) {
        if (displayLog) {
            System.out.println("[" + LogUtil.getSystemDateTime() + "]" + msg);
        }
        if (writeLog) {
            try {
                outs = new FileWriter(filename, true);
                outs.write("[" + LogUtil.getSystemDateTime() + "]" + msg + "\n");
                outs.close();
            }
            catch (IOException ex) {
                System.out.println("--- error to write log[" + filename + "]! ---");
            }
        }
    }

    public static String getSystemDateTime() {
        GregorianCalendar cd1 = new GregorianCalendar();
        String dateTime = "";
        int s_yy = cd1.get(1);
        dateTime = dateTime + s_yy + "/";
        int s_mon = cd1.get(2) + 1;
        if (s_mon < 10) {
            dateTime = dateTime + "0";
        }
        dateTime = dateTime + s_mon + "/";
        int s_dd = cd1.get(5);
        if (s_dd < 10) {
            dateTime = dateTime + "0";
        }
        dateTime = dateTime + s_dd + " ";
        int s_hh = cd1.get(11);
        if (s_hh < 10) {
            dateTime = dateTime + "0";
        }
        dateTime = dateTime + s_hh + ":";
        int s_min = cd1.get(12);
        if (s_min < 10) {
            dateTime = dateTime + "0";
        }
        dateTime = dateTime + s_min + ":";
        int s_ss = cd1.get(13);
        if (s_ss < 10) {
            dateTime = dateTime + "0";
        }
        dateTime = dateTime + s_ss + "." + cd1.get(14);
        return dateTime;
    }

    public static void main(String[] args) {
        System.out.println("abc=" + TimeZone.getDefault().getRawOffset());
        Calendar calendar = Calendar.getInstance();
        System.out.println("ZONE_OFFSET: " + Calendar.getInstance().get(15) / 3600000);
        System.out.println("DST_OFFSET: " + calendar.get(16) / 3600000);
    }

    public boolean isDisplayLog() {
        return displayLog;
    }

    public void setDisplayLog(boolean displayLog) {
        LogUtil.displayLog = displayLog;
    }

    static {
        displayLog = false;
        writeLog = false;
    }
}

