/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.GlobalDefine;
import java.util.SortedMap;
import java.util.TreeMap;

public class SDRRecord {
    public static byte SENSOR_TYPE_TEMPERATURE = 1;
    public static byte SENSOR_TYPE_VOLTAGE = (byte)2;
    public static byte SENSOR_TYPE_FAN = (byte)4;
    public static byte SENSOR_TYPE_INTRUSION = (byte)5;
    public static byte SENSOR_TYPE_POWER_SUPPLY = (byte)8;
    public static byte SENSOR_TYPE_POWER_SUPPLY_AND_INTRUSION = (byte)121;
    private int recordID;
    private byte SDRVersion;
    private byte recordType;
    private byte recordLength;
    private byte sensorOwnerID;
    private byte sensorOwnerLUN;
    private byte sensorNumber;
    private byte entityID;
    private byte entityInstance;
    private byte sensorInitialization;
    private byte sensorCapabilities;
    private byte sensorType;
    private byte eventReadingTypeCode;
    private byte[] assertionEventMask_LowerThresholdReadingMask;
    private byte[] dassertionEventMask_UpperThresholdReadingMask;
    private byte[] discreteReadingMask_SettableThresholdMask_ReadableThreasholdMask;
    private byte sensorUnits1;
    private byte sensorUnits2;
    private byte sensorUnits3;
    private byte linearization;
    private int m;
    private byte tolerance;
    private int b;
    private byte accuracyExp;
    private int accuracy;
    private byte Rexp;
    private byte Bexp;
    private byte analogCharacteristicFlags;
    private int nominalReading;
    private int normalMaximum;
    private int normalMinimum;
    private byte sensorMaximumReading;
    private byte sensorMinimumReading;
    private byte upperNonRecoverableThreshold;
    private byte upperCriticalThreshold;
    private byte upperNonCriticalThreshold;
    private byte lowerNonRecoverableThreshold;
    private byte lowerCriticalThreshold;
    private byte lowerNonCriticalThreshold;
    private byte positiveGoingThresholdHysteresisValue;
    private byte negativeGoingThresholdHysteresisValue;
    private byte reserved45;
    private byte reserved46;
    private byte OEM;
    private byte idStringType;
    private byte[] idStringBytes;
    private byte sensorDirection;
    public static SortedMap sensorNumberToSensorName = new TreeMap();
    public static SortedMap sensorNameToSensorNumber = new TreeMap();
    private byte currentValue;
    private boolean isValueAvailable = true;
    private byte[] raw;

    public static SDRRecord fromRaw(byte[] raw) {
        SDRRecord sdrRecord = new SDRRecord();
        int index = 0;
        sdrRecord.recordID = (raw[0] & 0xFF) + ((raw[1] & 0xFF) << 8);
        sdrRecord.SDRVersion = raw[index += 2];
        sdrRecord.recordType = raw[++index];
        sdrRecord.recordLength = raw[++index];
        sdrRecord.sensorOwnerID = raw[++index];
        sdrRecord.sensorOwnerLUN = raw[++index];
        sdrRecord.sensorNumber = raw[++index];
        sdrRecord.entityID = raw[++index];
        sdrRecord.entityInstance = raw[++index];
        sdrRecord.sensorInitialization = raw[++index];
        sdrRecord.sensorCapabilities = raw[++index];
        sdrRecord.sensorType = raw[++index];
        sdrRecord.eventReadingTypeCode = raw[++index];
        sdrRecord.assertionEventMask_LowerThresholdReadingMask = new byte[2];
        sdrRecord.dassertionEventMask_UpperThresholdReadingMask = new byte[2];
        sdrRecord.discreteReadingMask_SettableThresholdMask_ReadableThreasholdMask = new byte[2];
        System.arraycopy(raw, ++index, sdrRecord.assertionEventMask_LowerThresholdReadingMask, 0, 2);
        System.arraycopy(raw, index += 2, sdrRecord.dassertionEventMask_UpperThresholdReadingMask, 0, 2);
        System.arraycopy(raw, index += 2, sdrRecord.discreteReadingMask_SettableThresholdMask_ReadableThreasholdMask, 0, 2);
        sdrRecord.sensorUnits1 = raw[index += 2];
        sdrRecord.sensorUnits2 = raw[++index];
        sdrRecord.sensorUnits3 = raw[++index];
        sdrRecord.linearization = raw[++index];
        sdrRecord.m = (raw[++index + 1] & 0xC0) * 4 + (raw[index] & 0xFF);
        if (sdrRecord.m >= 512) {
            sdrRecord.m = -(512 - (sdrRecord.m & 0x1FF));
        }
        sdrRecord.tolerance = (byte)(raw[++index] & 0x3F);
        sdrRecord.b = (raw[++index + 1] & 0xC0) * 4 + (raw[index] & 0xFF);
        if (sdrRecord.b >= 512) {
            sdrRecord.b = -(512 - (sdrRecord.b & 0x1FF));
        }
        sdrRecord.accuracy = (raw[++index + 1] & 0xF0) * 4 + (byte)(raw[index] & 0x3F);
        sdrRecord.accuracyExp = (byte)((raw[++index] & 0xC) >> 2);
        sdrRecord.sensorDirection = (byte)(raw[index] & 3);
        sdrRecord.Rexp = (byte)((raw[++index] & 0xF0) >> 4);
        if (sdrRecord.Rexp >= 8) {
            sdrRecord.Rexp = (byte)(-(8 - (sdrRecord.Rexp & 7)));
        }
        sdrRecord.Bexp = (byte)(raw[index] & 0xF);
        if (sdrRecord.Bexp >= 8) {
            sdrRecord.Bexp = (byte)(-(8 - (sdrRecord.Bexp & 7)));
        }
        sdrRecord.analogCharacteristicFlags = raw[++index];
        sdrRecord.nominalReading = raw[++index] & 0xFF;
        sdrRecord.normalMaximum = raw[++index] & 0xFF;
        sdrRecord.normalMinimum = raw[++index] & 0xFF;
        sdrRecord.sensorMaximumReading = raw[++index];
        sdrRecord.sensorMinimumReading = raw[++index];
        sdrRecord.upperNonRecoverableThreshold = raw[++index];
        sdrRecord.upperCriticalThreshold = raw[++index];
        sdrRecord.upperNonCriticalThreshold = raw[++index];
        sdrRecord.lowerNonRecoverableThreshold = raw[++index];
        sdrRecord.lowerCriticalThreshold = raw[++index];
        sdrRecord.lowerNonCriticalThreshold = raw[++index];
        sdrRecord.positiveGoingThresholdHysteresisValue = raw[++index];
        sdrRecord.negativeGoingThresholdHysteresisValue = raw[++index];
        sdrRecord.reserved45 = raw[++index];
        sdrRecord.reserved46 = raw[++index];
        sdrRecord.OEM = raw[++index];
        sdrRecord.idStringType = raw[++index];
        sdrRecord.idStringBytes = new byte[raw.length - ++index];
        System.arraycopy(raw, index, sdrRecord.idStringBytes, 0, raw.length - index);
        sensorNumberToSensorName.put("" + (sdrRecord.getSensorNumber() & 0xFF), sdrRecord.getSensorName());
        sensorNameToSensorNumber.put(sdrRecord.getSensorName(), "" + (sdrRecord.getSensorNumber() & 0xFF));
        return sdrRecord;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Record ID          = " + this.recordID + " \n");
        sb.append("SDRVersion         = " + ByteUtility.byteToHex(this.SDRVersion) + "h \n");
        sb.append("recordType         = " + ByteUtility.byteToHex(this.recordType) + "h \n");
        sb.append("recordLength       = " + ByteUtility.byteToHex(this.recordLength) + "h \n");
        sb.append("sensorOwnerID      = " + ByteUtility.byteToHex(this.sensorOwnerID) + "h \n");
        sb.append("sensorOwnerLUN     = " + ByteUtility.byteToHex(this.sensorOwnerLUN) + "h \n");
        sb.append("sensorNumber       = " + ByteUtility.byteToHex(this.sensorNumber) + "h \n");
        sb.append("entityID           = " + ByteUtility.byteToHex(this.entityID) + "h \n");
        sb.append("entityInstance     = " + ByteUtility.byteToHex(this.entityInstance) + "h \n");
        sb.append("sensorInitialization = " + ByteUtility.byteToHex(this.sensorInitialization) + "h \n");
        sb.append("sensorCapabilities   = " + ByteUtility.byteToHex(this.sensorCapabilities) + "h \n");
        sb.append("sensorType           = " + ByteUtility.byteToHex(this.sensorType) + "h \n");
        sb.append("eventReadingTypeCode = " + ByteUtility.byteToHex(this.eventReadingTypeCode) + "h \n");
        sb.append("assertionEventMask_LowerThresholdReadingMask  = " + ByteUtility.bytesToHex(this.assertionEventMask_LowerThresholdReadingMask) + "\n");
        sb.append("dassertionEventMask_UpperThresholdReadingMask = " + ByteUtility.bytesToHex(this.dassertionEventMask_UpperThresholdReadingMask) + "\n");
        sb.append("discreteReadingMask_SettableThresholdMask_ReadableThreasholdMask = " + ByteUtility.bytesToHex(this.discreteReadingMask_SettableThresholdMask_ReadableThreasholdMask) + "\n");
        sb.append("sensorUnits1   = " + ByteUtility.byteToHex(this.sensorUnits1) + "h \n");
        sb.append("sensorUnits2   = " + ByteUtility.byteToHex(this.sensorUnits2) + "h \n");
        sb.append("sensorUnits3   = " + ByteUtility.byteToHex(this.sensorUnits3) + "h \n");
        sb.append("linearization  = " + ByteUtility.byteToHex(this.linearization) + "h \n");
        sb.append("m              = " + this.m + "h \n");
        sb.append("tolerance    = " + ByteUtility.byteToHex(this.tolerance) + "h \n");
        sb.append("b              = " + this.b + "h \n");
        sb.append("accuracy       = " + this.accuracy + "h \n");
        sb.append("accuracy exp   = " + ByteUtility.byteToHex(this.accuracyExp) + "h \n");
        sb.append("sensorDirection= " + ByteUtility.byteToHex(this.sensorDirection) + "h \n");
        sb.append("Rexp           = " + ByteUtility.byteToHex(this.Rexp) + "h \n");
        sb.append("Bexp           = " + ByteUtility.byteToHex(this.Bexp) + "h \n");
        sb.append("analogCharacteristicFlags  = " + ByteUtility.byteToHex(this.analogCharacteristicFlags) + "h \n");
        sb.append("nominalReading             = " + this.nominalReading + "\n");
        sb.append("normalMaximum              = " + this.normalMaximum + "\n");
        sb.append("normalMinimum              = " + this.normalMinimum + "\n");
        sb.append("sensorMaximumReading       = " + ByteUtility.byteToHex(this.sensorMaximumReading) + "h \n");
        sb.append("sensorMinimumReading       = " + ByteUtility.byteToHex(this.sensorMinimumReading) + "h \n");
        sb.append("upperNonRecoverableThreshold  = " + ByteUtility.byteToHex(this.upperNonRecoverableThreshold) + "h \n");
        sb.append("upperCriticalThreshold        = " + ByteUtility.byteToHex(this.upperCriticalThreshold) + "h \n");
        sb.append("upperNonCriticalThreshold     = " + ByteUtility.byteToHex(this.upperNonCriticalThreshold) + "h \n");
        sb.append("lowerNonRecoverableThreshold  = " + ByteUtility.byteToHex(this.lowerNonRecoverableThreshold) + "h \n");
        sb.append("lowerCriticalThreshold        = " + ByteUtility.byteToHex(this.lowerCriticalThreshold) + "h \n");
        sb.append("lowerNonCriticalThreshold     = " + ByteUtility.byteToHex(this.lowerNonCriticalThreshold) + "h \n");
        sb.append("positiveGoingThresholdHysteresisValue  = " + ByteUtility.byteToHex(this.positiveGoingThresholdHysteresisValue) + "h \n");
        sb.append("negativeGoingThresholdHysteresisValue  = " + ByteUtility.byteToHex(this.negativeGoingThresholdHysteresisValue) + "h \n");
        sb.append("reserved45  = " + ByteUtility.byteToHex(this.reserved45) + "h \n");
        sb.append("reserved46  = " + ByteUtility.byteToHex(this.reserved46) + "h \n");
        sb.append("OEM         = " + ByteUtility.byteToHex(this.OEM) + "h \n");
        sb.append("idStringType  = " + ByteUtility.byteToHex(this.idStringType) + "h \n");
        sb.append("idStringBytes = " + ByteUtility.bytesToHex(this.idStringBytes) + "\n");
        sb.append("idStringBytes(String) = " + new String(this.idStringBytes) + "\n");
        return sb.toString();
    }

    public String toSensorString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Sensor         = " + this.getSensorName() + " \n");
        sb.append("linearization  = " + ByteUtility.byteToHex(this.linearization) + "h \n");
        sb.append("m              = " + this.m + " \n");
        sb.append("b              = " + this.b + " \n");
        sb.append("Rexp           = " + this.Rexp + " \n");
        sb.append("Bexp           = " + this.Bexp + " \n");
        sb.append("sensorUnits1   = " + ByteUtility.byteToHex(this.sensorUnits1) + "h \n");
        sb.append("nominalReading             = " + this.nominalReading + " \n");
        sb.append("normalMaximum              = " + this.normalMaximum + " \n");
        sb.append("normalMinimum              = " + this.normalMinimum + " \n");
        sb.append("eventReadingTypeCode = " + ByteUtility.byteToHex(this.eventReadingTypeCode) + "h \n");
        return sb.toString();
    }

    public String toEileenString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Sensor             = " + this.getSensorName() + " \n");
        sb.append("sensorNumber       = " + ByteUtility.byteToHex(this.sensorNumber) + "h \n");
        sb.append("Unit               = " + this.getUnit() + "\n");
        sb.append("nominalReading       = " + this.calSensorReading(this.nominalReading & 0xFF) + "\n");
        sb.append("normalMaximum        = " + this.calSensorReading(this.normalMaximum & 0xFF) + " \n");
        sb.append("normalMinimum        = " + this.calSensorReading(this.normalMinimum & 0xFF) + " \n");
        sb.append("nominalReading(H)     = " + ByteUtility.byteToHex((byte)this.nominalReading) + "\n");
        sb.append("normalMaximum(H)     = " + ByteUtility.byteToHex((byte)this.normalMaximum) + " \n");
        sb.append("normalMinimum(H)     = " + ByteUtility.byteToHex((byte)this.normalMinimum) + " \n");
        sb.append("upperNonRecoverableThreshold  = " + this.calSensorReading(this.upperNonRecoverableThreshold & 0xFF) + "\n");
        sb.append("upperCriticalThreshold        = " + this.calSensorReading(this.upperCriticalThreshold & 0xFF) + " \n");
        sb.append("upperNonCriticalThreshold     = " + this.calSensorReading(this.upperNonCriticalThreshold & 0xFF) + " \n");
        sb.append("lowerNonRecoverableThreshold  = " + this.calSensorReading(this.lowerNonRecoverableThreshold & 0xFF) + " \n");
        sb.append("lowerCriticalThreshold        = " + this.calSensorReading(this.lowerCriticalThreshold & 0xFF) + " \n");
        sb.append("lowerNonCriticalThreshold     = " + this.calSensorReading(this.lowerNonCriticalThreshold & 0xFF) + " \n\n");
        return sb.toString();
    }

    public String getSensorTypeName() {
        return GlobalDefine.getSensorType(this.sensorType);
    }

    public String getSensorName() {
        return new String(this.idStringBytes).trim();
    }

    public double getReading() {
        return this.calSensorReading(this.nominalReading);
    }

    public double getHiLimit() {
        return this.calSensorReading(this.normalMaximum);
    }

    public double getLowLimit() {
        return this.calSensorReading(this.normalMinimum);
    }

    public double getCurrentReading() {
        return this.calSensorReading(this.currentValue & 0xFF);
    }

    public double calSensorReading(int reading) {
        double rawx = ((double)(this.m * reading) + (double)this.b * Math.pow(10.0, this.Bexp)) * Math.pow(10.0, this.Rexp);
        switch (this.linearization) {
            case 0: {
                break;
            }
            case 1: {
                rawx = Math.log(rawx);
                break;
            }
            case 2: {
                rawx = Math.log10(rawx);
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                rawx = Math.exp(rawx);
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                rawx = 1.0 / rawx;
                break;
            }
            case 8: {
                rawx = Math.sqrt(rawx);
                break;
            }
            case 9: {
                rawx = Math.cbrt(rawx);
                break;
            }
            case 10: {
                rawx = Math.sqrt(rawx);
                break;
            }
            case 11: {
                rawx = 1.0 / Math.cbrt(rawx);
            }
        }
        return rawx;
    }

    public String getUnit() {
        String unit = "";
        switch (this.sensorUnits2) {
            case 0: {
                unit = "unspecified";
                break;
            }
            case 1: {
                unit = "degree C";
                break;
            }
            case 2: {
                unit = "degree F";
                break;
            }
            case 3: {
                unit = "degree K";
                break;
            }
            case 4: {
                unit = "Volts";
                break;
            }
            case 18: {
                unit = "RPM";
                break;
            }
        }
        return unit;
    }

    public void setRecordID(int recordID) {
        this.recordID = recordID;
    }

    public void setRecordType(byte recordType) {
        this.recordType = recordType;
    }

    public void setRecordLength(byte recordLength) {
        this.recordLength = recordLength;
    }

    public void setSensorOwnerID(byte sensorOwnerID) {
        this.sensorOwnerID = sensorOwnerID;
    }

    public void setSensorOwnerLUN(byte sensorOwnerLUN) {
        this.sensorOwnerLUN = sensorOwnerLUN;
    }

    public void setSensorNumber(byte sensorNumber) {
        this.sensorNumber = sensorNumber;
    }

    public void setEntityID(byte entityID) {
        this.entityID = entityID;
    }

    public void setEntityInstance(byte entityInstance) {
        this.entityInstance = entityInstance;
    }

    public void setSensorInitialization(byte sensorInitialization) {
        this.sensorInitialization = sensorInitialization;
    }

    public void setSensorCapabilities(byte sensorCapabilities) {
        this.sensorCapabilities = sensorCapabilities;
    }

    public void setSensorType(byte sensorType) {
        this.sensorType = sensorType;
    }

    public void setEventReadingTypeCode(byte eventReadingTypeCode) {
        this.eventReadingTypeCode = eventReadingTypeCode;
    }

    public void setAssertionEventMask_LowerThresholdReadingMask(byte[] assertionEventMask_LowerThresholdReadingMask) {
        this.assertionEventMask_LowerThresholdReadingMask = assertionEventMask_LowerThresholdReadingMask;
    }

    public void setDassertionEventMask_UpperThresholdReadingMask(byte[] dassertionEventMask_UpperThresholdReadingMask) {
        this.dassertionEventMask_UpperThresholdReadingMask = dassertionEventMask_UpperThresholdReadingMask;
    }

    public void setDiscreteReadingMask_SettableThresholdMask_ReadableThreasholdMask(byte[] discreteReadingMask_SettableThresholdMask_ReadableThreasholdMask) {
        this.discreteReadingMask_SettableThresholdMask_ReadableThreasholdMask = discreteReadingMask_SettableThresholdMask_ReadableThreasholdMask;
    }

    public void setSensorUnits1(byte sensorUnits1) {
        this.sensorUnits1 = sensorUnits1;
    }

    public void setSensorUnits2(byte sensorUnits2) {
        this.sensorUnits2 = sensorUnits2;
    }

    public void setSensorUnits3(byte sensorUnits3) {
        this.sensorUnits3 = sensorUnits3;
    }

    public void setM(int m) {
        this.m = m;
    }

    public void setTolerance(byte tolerance) {
        this.tolerance = tolerance;
    }

    public void setB(int b) {
        this.b = b;
    }

    public void setAccuracyExp(byte accuracyExp) {
        this.accuracyExp = accuracyExp;
    }

    public void setAccuracy(int accuracy) {
        this.accuracy = accuracy;
    }

    public void setAnalogCharacteristicFlags(byte analogCharacteristicFlags) {
        this.analogCharacteristicFlags = analogCharacteristicFlags;
    }

    public void setNominalReading(int nominalReading) {
        this.nominalReading = nominalReading;
    }

    public void setNormalMaximum(int normalMaximum) {
        this.normalMaximum = normalMaximum;
    }

    public void setNormalMinimum(int normalMinimum) {
        this.normalMinimum = normalMinimum;
    }

    public void setSensorMaximumReading(byte sensorMaximumReading) {
        this.sensorMaximumReading = sensorMaximumReading;
    }

    public void setSensorMinimumReading(byte sensorMinimumReading) {
        this.sensorMinimumReading = sensorMinimumReading;
    }

    public void setUpperNonRecoverableThreshold(byte upperNonRecoverableThreshold) {
        this.upperNonRecoverableThreshold = upperNonRecoverableThreshold;
    }

    public void setUpperCriticalThreshold(byte upperCriticalThreshold) {
        this.upperCriticalThreshold = upperCriticalThreshold;
    }

    public void setUpperNonCriticalThreshold(byte upperNonCriticalThreshold) {
        this.upperNonCriticalThreshold = upperNonCriticalThreshold;
    }

    public void setLowerCriticalThreshold(byte lowerCriticalThreshold) {
        this.lowerCriticalThreshold = lowerCriticalThreshold;
    }

    public void setLowerNonCriticalThreshold(byte lowerNonCriticalThreshold) {
        this.lowerNonCriticalThreshold = lowerNonCriticalThreshold;
    }

    public void setLowerNonRecoverableThreshold(byte lowerNonRecoverableThreshold) {
        this.lowerNonRecoverableThreshold = lowerNonRecoverableThreshold;
    }

    public void setPositiveGoingThresholdHysteresisValue(byte positiveGoingThresholdHysteresisValue) {
        this.positiveGoingThresholdHysteresisValue = positiveGoingThresholdHysteresisValue;
    }

    public void setNegativeGoingThresholdHysteresisValue(byte negativeGoingThresholdHysteresisValue) {
        this.negativeGoingThresholdHysteresisValue = negativeGoingThresholdHysteresisValue;
    }

    public void setReserved45(byte reserved45) {
        this.reserved45 = reserved45;
    }

    public void setReserved46(byte reserved46) {
        this.reserved46 = reserved46;
    }

    public void setIdStringType(byte idStringType) {
        this.idStringType = idStringType;
    }

    public void setIdStringBytes(byte[] idStringBytes) {
        this.idStringBytes = idStringBytes;
    }

    public void setLinearization(byte linearization) {
        this.linearization = linearization;
    }

    public void setSensorDirection(byte sensorDirection) {
        this.sensorDirection = sensorDirection;
    }

    public void setCurrentValue(byte currentValue) {
        this.currentValue = currentValue;
    }

    public void setIsValueAvailable(boolean isValueAvailable) {
        this.isValueAvailable = isValueAvailable;
    }

    public void setRaw(byte[] raw) {
        this.raw = raw;
    }

    public void setBexp(byte Bexp) {
        this.Bexp = Bexp;
    }

    public void setRexp(byte Rexp) {
        this.Rexp = Rexp;
    }

    public void setOEM(byte OEM) {
        this.OEM = OEM;
    }

    public void setSDRVersion(byte SDRVersion) {
        this.SDRVersion = SDRVersion;
    }

    public int getRecordID() {
        return this.recordID;
    }

    public byte getRecordType() {
        return this.recordType;
    }

    public byte getRecordLength() {
        return this.recordLength;
    }

    public byte getSensorOwnerID() {
        return this.sensorOwnerID;
    }

    public byte getSensorOwnerLUN() {
        return this.sensorOwnerLUN;
    }

    public byte getSensorNumber() {
        return this.sensorNumber;
    }

    public byte getEntityID() {
        return this.entityID;
    }

    public byte getEntityInstance() {
        return this.entityInstance;
    }

    public byte getSensorInitialization() {
        return this.sensorInitialization;
    }

    public byte getSensorCapabilities() {
        return this.sensorCapabilities;
    }

    public byte getSensorType() {
        return this.sensorType;
    }

    public byte getEventReadingTypeCode() {
        return this.eventReadingTypeCode;
    }

    public byte[] getAssertionEventMask_LowerThresholdReadingMask() {
        return this.assertionEventMask_LowerThresholdReadingMask;
    }

    public byte[] getDassertionEventMask_UpperThresholdReadingMask() {
        return this.dassertionEventMask_UpperThresholdReadingMask;
    }

    public byte[] getDiscreteReadingMask_SettableThresholdMask_ReadableThreasholdMask() {
        return this.discreteReadingMask_SettableThresholdMask_ReadableThreasholdMask;
    }

    public byte getSensorUnits1() {
        return this.sensorUnits1;
    }

    public byte getSensorUnits2() {
        return this.sensorUnits2;
    }

    public byte getSensorUnits3() {
        return this.sensorUnits3;
    }

    public int getM() {
        return this.m;
    }

    public byte getTolerance() {
        return this.tolerance;
    }

    public int getB() {
        return this.b;
    }

    public byte getAccuracyExp() {
        return this.accuracyExp;
    }

    public int getAccuracy() {
        return this.accuracy;
    }

    public byte getAnalogCharacteristicFlags() {
        return this.analogCharacteristicFlags;
    }

    public int getNominalReading() {
        return this.nominalReading;
    }

    public int getNormalMaximum() {
        return this.normalMaximum;
    }

    public int getNormalMinimum() {
        return this.normalMinimum;
    }

    public byte getSensorMaximumReading() {
        return this.sensorMaximumReading;
    }

    public byte getSensorMinimumReading() {
        return this.sensorMinimumReading;
    }

    public byte getUpperNonRecoverableThreshold() {
        return this.upperNonRecoverableThreshold;
    }

    public byte getUpperCriticalThreshold() {
        return this.upperCriticalThreshold;
    }

    public byte getUpperNonCriticalThreshold() {
        return this.upperNonCriticalThreshold;
    }

    public byte getLowerCriticalThreshold() {
        return this.lowerCriticalThreshold;
    }

    public byte getLowerNonCriticalThreshold() {
        return this.lowerNonCriticalThreshold;
    }

    public byte getLowerNonRecoverableThreshold() {
        return this.lowerNonRecoverableThreshold;
    }

    public byte getPositiveGoingThresholdHysteresisValue() {
        return this.positiveGoingThresholdHysteresisValue;
    }

    public byte getNegativeGoingThresholdHysteresisValue() {
        return this.negativeGoingThresholdHysteresisValue;
    }

    public byte getReserved45() {
        return this.reserved45;
    }

    public byte getReserved46() {
        return this.reserved46;
    }

    public byte getIdStringType() {
        return this.idStringType;
    }

    public byte[] getIdStringBytes() {
        return this.idStringBytes;
    }

    public byte getLinearization() {
        return this.linearization;
    }

    public byte getSensorDirection() {
        return this.sensorDirection;
    }

    public byte getCurrentValue() {
        return this.currentValue;
    }

    public boolean isIsValueAvailable() {
        return this.isValueAvailable;
    }

    public byte[] getRaw() {
        return this.raw;
    }

    public byte getBexp() {
        return this.Bexp;
    }

    public byte getRexp() {
        return this.Rexp;
    }

    public byte getOEM() {
        return this.OEM;
    }

    public byte getSDRVersion() {
        return this.SDRVersion;
    }

    public String doubleToString(double value) {
        int temp = (int)(value * 100.0);
        double d = (double)temp / 100.0;
        return "" + d;
    }
}

