/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi;

import com.supermicro.ipmi.CipherSuite;
import com.supermicro.ipmi.IPMIChassisCommand;
import com.supermicro.ipmi.IPMIGlobalCommand;
import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.IPMINetworkInterface;
import com.supermicro.ipmi.IPMIPayloadCommand;
import com.supermicro.ipmi.IPMISOLCommand;
import com.supermicro.ipmi.IPMIVersion;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.MessageCenter;
import com.supermicro.ipmi.RMCP;
import com.supermicro.ipmi.RMCPPlus;
import com.supermicro.ipmi.SOLMessage;
import com.supermicro.ipmi.Timeout;
import com.supermicro.ipmi.sol.SOLPacketSender;
import java.util.HashMap;
import java.util.Observable;
import java.util.Observer;
import java.util.Timer;
import java.util.TimerTask;

public class SOLSessionController
implements ISessionController,
Observer {
    ISessionController sessionController;
    IPMIGlobalCommand ipmiGlobalCommand;
    IPMIChassisCommand ipmiChassisCommand;
    IPMIMessagingCommand ipmiMessagingCommand;
    IPMIPayloadCommand ipmiPayloadCommand;
    IPMISOLCommand ipmiSOLCommand;
    IPMINetworkInterface ipmiNetworkInterface;
    IPMIInterfaceConfig ipmiInterfaceConfig;
    public static int solTimeout = 500;
    byte baudRate = 0;
    HashMap solSeqToSolMessage = new HashMap();
    byte solSequence = 1;
    public boolean isSOLActivated = false;
    Timer timer;
    SOLPacketSender solPacketSender = null;

    public void setBaudRate(byte baudRateIndex) {
        this.baudRate = baudRateIndex;
    }

    public IPMINetworkInterface startup(IPMIInterfaceConfig config) {
        this.sessionController = IPMIVersion.getSessionController(config);
        if (this.sessionController == null) {
            MessageCenter.getInstance().put(this, (Object)"Network error 1");
            return null;
        }
        this.ipmiGlobalCommand = new IPMIGlobalCommand(null);
        this.ipmiChassisCommand = new IPMIChassisCommand(null);
        this.ipmiMessagingCommand = new IPMIMessagingCommand(null);
        this.ipmiPayloadCommand = new IPMIPayloadCommand(null);
        this.ipmiSOLCommand = new IPMISOLCommand(null);
        this.ipmiInterfaceConfig = config;
        this.ipmiNetworkInterface = this.sessionController.startup(config);
        if (this.ipmiNetworkInterface != null) {
            if (this.ipmiNetworkInterface instanceof RMCP) {
                MessageCenter.getInstance().put(this, (Object)"RMCP Login successfully");
            } else if (this.ipmiNetworkInterface instanceof RMCPPlus) {
                MessageCenter.getInstance().put(this, (Object)"RMCP+ Login successfully");
            }
        } else {
            MessageCenter.getInstance().put(this, (Object)"Network error 2");
            return null;
        }
        this.ipmiGlobalCommand.setIPMIInterface(this.ipmiNetworkInterface);
        this.ipmiChassisCommand.setIPMIInterface(this.ipmiNetworkInterface);
        this.ipmiMessagingCommand.setIPMIInterface(this.ipmiNetworkInterface);
        this.ipmiPayloadCommand.setIPMIInterface(this.ipmiNetworkInterface);
        this.ipmiSOLCommand.setIPMIInterface(this.ipmiNetworkInterface);
        if (this.ipmiNetworkInterface instanceof RMCP) {
            this.activatePayloadByRMCP(config);
        } else if (this.ipmiNetworkInterface instanceof RMCPPlus) {
            this.activatePayloadByRMCPPlus(config);
        }
        return this.ipmiNetworkInterface;
    }

    private void activatePayloadByRMCP(IPMIInterfaceConfig config) {
        boolean result = this.ipmiPayloadCommand.activateSOLPayload(false);
        if (result) {
            MessageCenter.getInstance().put(this, (Object)"activate SOL ok");
            this.ipmiNetworkInterface.startListen();
            this.keepSession(true);
            this.isSOLActivated = true;
        } else {
            this.isSOLActivated = false;
            MessageCenter.getInstance().put(this, (Object)"activate SOL failed");
        }
    }

    private void activatePayloadByRMCPPlus(IPMIInterfaceConfig config) {
        boolean result;
        byte userID = this.ipmiMessagingCommand.getUserIDByName(config.getUserName());
        if (config.getPrivilege() == 4) {
            int data = 0;
            if (CipherSuite.getIntegrityAlgorithmByID(config.getCipherSuiteID()) > 0) {
                data = (byte)(data | 0x40);
            }
            if (CipherSuite.getConfidentialityAlgorithmByID(config.getCipherSuiteID()) > 0) {
                data = (byte)(data | 0x80);
            }
            this.ipmiSOLCommand.setSOLEnable();
            this.ipmiSOLCommand.setSOLRetry((byte)7, (byte)100);
            this.ipmiPayloadCommand.setUserPayloadForSOL(userID);
            if (this.baudRate != 0) {
                this.ipmiSOLCommand.setSOLBitRateNonVolatile(this.baudRate);
                this.ipmiSOLCommand.setSOLBitRateVolatile(this.baudRate);
            }
        }
        if (result = this.ipmiPayloadCommand.activateSOLPayload(config.getCipherSuiteID() > 0)) {
            MessageCenter.getInstance().put(this, (Object)"activate SOL ok");
            this.ipmiNetworkInterface.startListen();
            this.keepSession(true);
            this.isSOLActivated = true;
        } else {
            this.isSOLActivated = false;
            MessageCenter.getInstance().put(this, (Object)"activate SOL failed");
        }
    }

    public boolean closeSession() {
        boolean r1 = false;
        boolean r2 = false;
        if (this.isSOLActivated) {
            this.keepSession(false);
            this.ipmiNetworkInterface.stopListen();
            r1 = this.ipmiPayloadCommand.deactivateSOLPayload();
            if (r1) {
                MessageCenter.getInstance().put(this, (Object)"deactivate SOL ok");
            } else {
                MessageCenter.getInstance().put(this, (Object)"deactivate SOL fail");
            }
            r2 = this.sessionController.closeSession();
            if (r2) {
                MessageCenter.getInstance().put(this, (Object)"close session ok");
            } else {
                MessageCenter.getInstance().put(this, (Object)"close session fail");
            }
        }
        this.ipmiNetworkInterface.stopProxy();
        return r2;
    }

    public void keepSession(boolean flag) {
        if (flag) {
            TimerTask timerTask = new TimerTask(){

                public void run() {
                    SOLSessionController.this.ipmiGlobalCommand.dropGetDeviceIDCommand();
                }
            };
            this.timer = new Timer();
            this.timer.schedule(timerTask, 0L, 5000L);
        } else {
            this.timer.cancel();
            this.timer = null;
        }
    }

    public void incSOLSequnce() {
        this.solSequence = (byte)(this.solSequence + 1);
        if (this.solSequence > 15) {
            this.solSequence = 1;
        }
    }

    public void dropKey(byte key, SOLPacketSender solPacketSender) {
        this.solPacketSender = solPacketSender;
        SOLMessage solMessage = new SOLMessage();
        solMessage.setPacketSequenceNumber(this.solSequence);
        solMessage.setPacketACKandNACKSequenceNumber((byte)0);
        solMessage.setOperation((byte)0);
        solMessage.setCharacterCount((byte)0);
        solMessage.data = new byte[1];
        solMessage.data[0] = key;
        this.solSeqToSolMessage.put(new Byte(solMessage.getPacketSequenceNumber()), solMessage);
        this.ipmiNetworkInterface.drop(solMessage);
        new Timeout(this, solPacketSender, solMessage.getPacketSequenceNumber()).start();
        this.incSOLSequnce();
    }

    public void dropKey(byte[] keys, SOLPacketSender solPacketSender) {
        this.solPacketSender = solPacketSender;
        SOLMessage solMessage = new SOLMessage();
        solMessage.setPacketSequenceNumber(this.solSequence);
        solMessage.setPacketACKandNACKSequenceNumber((byte)0);
        solMessage.setOperation((byte)0);
        solMessage.setCharacterCount((byte)0);
        solMessage.data = new byte[keys.length];
        solMessage.getPacketSequenceNumber();
        System.arraycopy(keys, 0, solMessage.data, 0, keys.length);
        this.solSeqToSolMessage.put(new Byte(solMessage.getPacketSequenceNumber()), solMessage);
        this.ipmiNetworkInterface.drop(solMessage);
        new Timeout(this, solPacketSender, solMessage.getPacketSequenceNumber()).start();
        this.incSOLSequnce();
    }

    public void dropKey(byte key) {
        SOLMessage solMessage = new SOLMessage();
        solMessage.setPacketSequenceNumber(this.solSequence);
        solMessage.setPacketACKandNACKSequenceNumber((byte)0);
        solMessage.setOperation((byte)0);
        solMessage.setCharacterCount((byte)0);
        solMessage.data = new byte[1];
        solMessage.data[0] = key;
        this.ipmiNetworkInterface.drop(solMessage);
        this.incSOLSequnce();
    }

    public void dropKey(byte[] keys) {
        SOLMessage solMessage = new SOLMessage();
        solMessage.setPacketSequenceNumber(this.solSequence);
        solMessage.setPacketACKandNACKSequenceNumber((byte)0);
        solMessage.setOperation((byte)0);
        solMessage.setCharacterCount((byte)0);
        solMessage.data = new byte[keys.length];
        solMessage.getPacketSequenceNumber();
        System.arraycopy(keys, 0, solMessage.data, 0, keys.length);
        this.ipmiNetworkInterface.drop(solMessage);
        this.incSOLSequnce();
    }

    public void update(Observable o, Object arg) {
        Byte ack;
        if (!(arg instanceof byte[]) && arg instanceof Byte && this.solSeqToSolMessage.containsKey(ack = (Byte)arg)) {
            this.solSeqToSolMessage.remove(ack);
            if (this.solPacketSender != null) {
                this.solPacketSender.storage.allowGet();
            }
        }
    }

    public static void main(String[] args) {
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setIp("192.168.1.118");
        config.setUserName("ADMIN");
        config.setPassword("ADMIN");
        config.setCipherSuiteID((byte)3);
        config.setPrivilege((byte)4);
        SOLSessionController solSessionController = new SOLSessionController();
        IPMINetworkInterface ipmiNetworkInterface = solSessionController.startup(config);
        if (solSessionController.isSOLActivated) {
            MessageCenter.getInstance().put("SOL activate OK");
        } else {
            MessageCenter.getInstance().put("SOL activate failed");
        }
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        for (int i = 0; i < 2; ++i) {
            byte[] keys = new byte[]{83, 79, 76, 13};
            solSessionController.dropKey(keys);
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
        }
        boolean result = solSessionController.closeSession();
        MessageCenter.getInstance().put("close session :" + result);
    }
}

