/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.blade;

import com.supermicro.ipmi.ByteUtility;
import java.util.Observable;

public class GigabitSwitchEntity
extends Observable {
    private boolean reset;
    private boolean powerOn;
    private boolean error;
    private boolean initOK;
    private byte present;
    private byte p2v5;
    private byte p1v25;
    private byte switchTemperature;
    private byte boardTemperature;
    private byte i2cError;
    private byte busNumber;
    private byte channel;
    private byte initialized;
    private byte pollCount;
    private byte selReportError;
    private byte flag;
    private byte reserve3;
    private byte reserve4;
    private byte reserve5;
    private byte reserve6;
    private byte reserve7;
    private byte reserve8;
    private byte[] raw;
    private int moduleIndex;

    public double p2v5Formula() {
        double v = (double)(0xFF & this.p2v5) * 0.008 * 2.0;
        return v;
    }

    public double p1v25Formula() {
        double v = (double)(0xFF & this.p1v25) * 0.008;
        return v;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("\nreset =" + this.reset);
        sb.append("\npowerOn =" + this.powerOn);
        sb.append("\nerror =" + this.error);
        sb.append("\ninitOK =" + this.initOK);
        sb.append("\npresent =" + this.present);
        sb.append("\np2v5 =" + ByteUtility.byteToHex(this.p2v5));
        sb.append("\np1v25 =" + ByteUtility.byteToHex(this.p1v25));
        sb.append("\nswitchTemperature =" + ByteUtility.byteToHex(this.switchTemperature));
        sb.append("\nboardTemperature =" + ByteUtility.byteToHex(this.boardTemperature));
        sb.append("\ni2cError =" + this.i2cError);
        sb.append("\nbusNumber =" + this.busNumber);
        sb.append("\nchannel =" + this.channel);
        sb.append("\ninitialized =" + this.initialized);
        sb.append("\npollCount =" + this.pollCount);
        sb.append("\nselReportError =" + this.selReportError);
        sb.append("\nflag =" + this.flag);
        sb.append("\nreserve3 =" + this.reserve3);
        sb.append("\nreserve4 =" + this.reserve4);
        sb.append("\nreserve5 =" + this.reserve5);
        sb.append("\nreserve6 =" + this.reserve6);
        sb.append("\nreserve7 =" + this.reserve7);
        sb.append("\nreserve8 =" + this.reserve8);
        sb.append("\nRAW =" + ByteUtility.bytesToHex(this.raw));
        return sb.toString();
    }

    public boolean fromRaw(byte[] raw) {
        if (raw.length != 19) {
            return false;
        }
        try {
            this.reset = (raw[0] & 1) == 1;
            this.powerOn = (raw[0] & 2) == 2;
            this.error = (raw[0] & 0x20) != 32;
            this.initOK = (raw[0] & 0x40) != 64;
            this.present = raw[1];
            this.p2v5 = raw[2];
            this.p1v25 = raw[3];
            this.switchTemperature = raw[4];
            this.boardTemperature = raw[5];
            this.i2cError = raw[6];
            this.busNumber = raw[7];
            this.channel = raw[8];
            this.initialized = raw[9];
            this.pollCount = raw[10];
            this.selReportError = raw[11];
            this.flag = raw[12];
            this.reserve3 = raw[13];
            this.reserve4 = raw[14];
            this.reserve5 = raw[15];
            this.reserve6 = raw[16];
            this.reserve7 = raw[17];
            this.reserve8 = raw[18];
            this.raw = raw;
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            return false;
        }
        return true;
    }

    public void setReset(boolean reset) {
        this.reset = reset;
    }

    public void setPowerOn(boolean powerOn) {
        this.powerOn = powerOn;
    }

    public void setError(boolean error) {
        this.error = error;
    }

    public void setInitOK(boolean initOK) {
        this.initOK = initOK;
    }

    public void setPresent(byte present) {
        this.present = present;
    }

    public void setP2v5(byte p2v5) {
        this.p2v5 = p2v5;
    }

    public void setP1v25(byte p1v25) {
        this.p1v25 = p1v25;
    }

    public void setSwitchTemperature(byte switchTemperature) {
        this.switchTemperature = switchTemperature;
    }

    public void setBoardTemperature(byte boardTemperature) {
        this.boardTemperature = boardTemperature;
    }

    public void setI2cError(byte i2cError) {
        this.i2cError = i2cError;
    }

    public void setBusNumber(byte busNumber) {
        this.busNumber = busNumber;
    }

    public void setChannel(byte channel) {
        this.channel = channel;
    }

    public void setInitialized(byte initialized) {
        this.initialized = initialized;
    }

    public void setPollCount(byte pollCount) {
        this.pollCount = pollCount;
    }

    public void setRaw(byte[] raw) {
        this.raw = raw;
    }

    public void setSELReportError(byte selReportError) {
        this.selReportError = selReportError;
    }

    public void setFlag(byte flag) {
        this.flag = flag;
    }

    public void setReserve3(byte reserve3) {
        this.reserve3 = reserve3;
    }

    public void setReserve4(byte reserve4) {
        this.reserve4 = reserve4;
    }

    public void setReserve5(byte reserve5) {
        this.reserve5 = reserve5;
    }

    public void setReserve6(byte reserve6) {
        this.reserve6 = reserve6;
    }

    public void setReserve7(byte reserve7) {
        this.reserve7 = reserve7;
    }

    public void setReserve8(byte reserve8) {
        this.reserve8 = reserve8;
    }

    public void setModuleIndex(int moduleIndex) {
        this.moduleIndex = moduleIndex;
    }

    public boolean isReset() {
        return this.reset;
    }

    public boolean isPowerOn() {
        return this.powerOn;
    }

    public boolean isError() {
        return this.error;
    }

    public boolean isInitOK() {
        return this.initOK;
    }

    public byte getPresent() {
        return this.present;
    }

    public byte getP2v5() {
        return this.p2v5;
    }

    public byte getP1v25() {
        return this.p1v25;
    }

    public byte getSwitchTemperature() {
        return this.switchTemperature;
    }

    public byte getBoardTemperature() {
        return this.boardTemperature;
    }

    public byte getI2cError() {
        return this.i2cError;
    }

    public byte getBusNumber() {
        return this.busNumber;
    }

    public byte getChannel() {
        return this.channel;
    }

    public byte getInitialized() {
        return this.initialized;
    }

    public byte getPollCount() {
        return this.pollCount;
    }

    public byte[] getRaw() {
        return this.raw;
    }

    public byte getSELReportError() {
        return this.selReportError;
    }

    public byte getFlag() {
        return this.flag;
    }

    public byte getReserve3() {
        return this.reserve3;
    }

    public byte getReserve4() {
        return this.reserve4;
    }

    public byte getReserve5() {
        return this.reserve5;
    }

    public byte getReserve6() {
        return this.reserve6;
    }

    public byte getReserve7() {
        return this.reserve7;
    }

    public byte getReserve8() {
        return this.reserve8;
    }

    public int getModuleIndex() {
        return this.moduleIndex;
    }

    public String toFormatedHeader() {
        String formatTemplate = " %-6s | %-5s | %-5s | %-4s | %8s | %6s | %6s\n";
        StringBuffer header = new StringBuffer();
        header.append(String.format(formatTemplate, "GBSW", "Power", "Error", "Init", "Switch", "2.5V", "1.25V"));
        header.append(String.format(formatTemplate, "----", "-----", "-----", "----", "------", "----", "-----"));
        return header.toString();
    }

    public String toFormatedString() {
        if (this.getPresent() == 0) {
            return "";
        }
        String formatTemplate = " %-6s | %-5s | %-5s | %-4s | %8s | %6s | %6s\n";
        StringBuffer formatedString = new StringBuffer();
        String index = "GBSW " + this.moduleIndex;
        String power = this.isPowerOn() ? "On" : "Off";
        String error = this.isError() ? "Error" : "";
        String initial = this.getInitialized() > 0 ? "OK" : "Failed";
        String boardTemp = this.showCandF(this.getSwitchTemperature());
        String v2v5 = this.p2v5Formula() + "V";
        String v1v25 = this.p1v25Formula() + "V";
        formatedString.append(String.format(formatTemplate, index, power, error, initial, boardTemp, v2v5, v1v25));
        return formatedString.toString();
    }

    protected String showCandF(byte c) {
        if (c == -127) {
            return "N/A";
        }
        long f = Math.round(1.8 * (double)c + 32.0);
        return c + "C/" + (f < 100L ? " " : "") + f + "F";
    }
}

