/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.blade;

import com.supermicro.ipmi.ByteUtility;
import java.util.Observable;

public class InfiniBandEntity
extends Observable {
    private boolean powerOn;
    private boolean powerReset;
    private byte present;
    private byte v33Aux;
    private byte vvdd;
    private byte v12;
    private byte v18;
    private byte v33;
    private byte temperature;
    private byte i2cError;
    private byte busNumber;
    private byte channel;
    private byte initialized;
    private byte pollCount;
    private byte flag;
    private byte reserve2;
    private byte reserve3;
    private byte reserve4;
    private byte reserve5;
    private byte reserve6;
    private byte reserve7;
    private byte reserve8;
    private byte[] raw;
    private int moduleIndex;

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("\npowerOn =" + this.powerOn);
        sb.append("\npowerReset =" + this.powerReset);
        sb.append("\npresent =" + this.present);
        sb.append("\nv33Aux =" + this.v33Aux);
        sb.append("\nvvdd =" + this.vvdd);
        sb.append("\nv12 =" + this.v12);
        sb.append("\nv18 =" + this.v18);
        sb.append("\nv33 =" + this.v33);
        sb.append("\ntemperature =" + this.temperature);
        sb.append("\ni2cError =" + this.i2cError);
        sb.append("\nbusNumber =" + this.busNumber);
        sb.append("\nchannel =" + this.channel);
        sb.append("\ninitialized =" + this.initialized);
        sb.append("\npollCount =" + this.pollCount);
        sb.append("\nflag =" + this.flag);
        sb.append("\nreserve2 =" + this.reserve2);
        sb.append("\nreserve3 =" + this.reserve3);
        sb.append("\nreserve4 =" + this.reserve4);
        sb.append("\nreserve5 =" + this.reserve5);
        sb.append("\nreserve6 =" + this.reserve6);
        sb.append("\nreserve7 =" + this.reserve7);
        sb.append("\nreserve8 =" + this.reserve8);
        sb.append("\nRAW =" + ByteUtility.bytesToHex(this.raw));
        return sb.toString();
    }

    public boolean fromRaw(byte[] raw) {
        if (raw.length != 22) {
            return false;
        }
        try {
            this.powerOn = (raw[0] & 1) != 1;
            this.powerReset = (raw[0] & 2) == 2;
            this.present = raw[2];
            this.v33Aux = raw[3];
            this.vvdd = raw[4];
            this.v12 = raw[5];
            this.v18 = raw[6];
            this.v33 = raw[7];
            this.temperature = raw[8];
            this.i2cError = raw[9];
            this.busNumber = raw[10];
            this.channel = raw[11];
            this.initialized = raw[12];
            this.pollCount = raw[13];
            this.flag = raw[14];
            this.reserve2 = raw[15];
            this.reserve3 = raw[16];
            this.reserve4 = raw[17];
            this.reserve5 = raw[18];
            this.reserve6 = raw[19];
            this.reserve7 = raw[20];
            this.reserve8 = raw[21];
            this.raw = raw;
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            return false;
        }
        return true;
    }

    public void setPowerOn(boolean powerOn) {
        this.powerOn = powerOn;
    }

    public void setPowerReset(boolean powerReset) {
        this.powerReset = powerReset;
    }

    public void setV33Aux(byte v33Aux) {
        this.v33Aux = v33Aux;
    }

    public void setVvdd(byte vvdd) {
        this.vvdd = vvdd;
    }

    public void setV12(byte v12) {
        this.v12 = v12;
    }

    public void setV18(byte v18) {
        this.v18 = v18;
    }

    public void setV33(byte v33) {
        this.v33 = v33;
    }

    public void setTemperature(byte temperature) {
        this.temperature = temperature;
    }

    public void setI2cError(byte i2cError) {
        this.i2cError = i2cError;
    }

    public void setBusNumber(byte busNumber) {
        this.busNumber = busNumber;
    }

    public void setChannel(byte channel) {
        this.channel = channel;
    }

    public void setInitialized(byte initialized) {
        this.initialized = initialized;
    }

    public void setPollCount(byte pollCount) {
        this.pollCount = pollCount;
    }

    public void setPresent(byte present) {
        this.present = present;
    }

    public void setRaw(byte[] raw) {
        this.raw = raw;
    }

    public void setFlag(byte flag) {
        this.flag = flag;
    }

    public void setReserve2(byte reserve2) {
        this.reserve2 = reserve2;
    }

    public void setReserve3(byte reserve3) {
        this.reserve3 = reserve3;
    }

    public void setReserve4(byte reserve4) {
        this.reserve4 = reserve4;
    }

    public void setReserve5(byte reserve5) {
        this.reserve5 = reserve5;
    }

    public void setReserve64(byte reserve6) {
        this.reserve6 = reserve6;
    }

    public void setReserve7(byte reserve7) {
        this.reserve7 = reserve7;
    }

    public void setReserve8(byte reserve8) {
        this.reserve8 = reserve8;
    }

    public void setModuleIndex(int moduleIndex) {
        this.moduleIndex = moduleIndex;
    }

    public boolean isPowerOn() {
        return this.powerOn;
    }

    public boolean isPowerReset() {
        return this.powerReset;
    }

    public byte getV33Aux() {
        return this.v33Aux;
    }

    public byte getVvdd() {
        return this.vvdd;
    }

    public byte getV12() {
        return this.v12;
    }

    public byte getV18() {
        return this.v18;
    }

    public byte getV33() {
        return this.v33;
    }

    public double getV33AuxFormula() {
        return (double)(this.v33Aux & 0xFF) * 3.6 / 256.0;
    }

    public double getVvddFormula() {
        return (double)(this.vvdd & 0xFF) * 3.333 / 256.0;
    }

    public double getV12Formula() {
        return (double)(this.v12 & 0xFF) * 3.6 / 256.0;
    }

    public double getV18Formula() {
        return (double)(this.v18 & 0xFF) * 6.66 / 256.0;
    }

    public double getV33Formula() {
        return (double)(this.v33 & 0xFF) * 16.0 / 256.0;
    }

    public byte getTemperature() {
        return this.temperature;
    }

    public byte getI2cError() {
        return this.i2cError;
    }

    public byte getBusNumber() {
        return this.busNumber;
    }

    public byte getChannel() {
        return this.channel;
    }

    public byte getInitialized() {
        return this.initialized;
    }

    public byte getPollCount() {
        return this.pollCount;
    }

    public byte getPresent() {
        return this.present;
    }

    public byte[] getRaw() {
        return this.raw;
    }

    public byte getFlag() {
        return this.flag;
    }

    public byte getReserve2() {
        return this.reserve2;
    }

    public byte getReserve3() {
        return this.reserve3;
    }

    public byte getReserve4() {
        return this.reserve4;
    }

    public byte getReserve5() {
        return this.reserve5;
    }

    public byte getReserve6() {
        return this.reserve6;
    }

    public byte getReserve7() {
        return this.reserve7;
    }

    public byte getReserve8() {
        return this.reserve8;
    }

    public int getModuleIndex() {
        return this.moduleIndex;
    }

    public String toFormatedHeader() {
        String formatTemplate = " %-4s | %-5s | %-4s | %5s | %8s | %5s | %5s | %5s | %7s\n";
        StringBuffer header = new StringBuffer();
        header.append(String.format(formatTemplate, "IB", "Power", "Init", "VVDD", "3.3V Aux", "1.2V", "1.8V", "3.3V", "Temp."));
        header.append(String.format(formatTemplate, "--", "-----", "----", "----", "--------", "----", "----", "----", "-----"));
        return header.toString();
    }

    public String toFormatedString() {
        if (this.getPresent() == 0) {
            return "";
        }
        String formatTemplate = " %-4s | %-5s | %-4s | %5s | %8s | %5s | %5s | %5s | %7s\n";
        StringBuffer formatedString = new StringBuffer();
        String index = "IB " + this.moduleIndex;
        String power = this.isPowerOn() ? "On" : " Off";
        String initial = this.getInitialized() > 0 ? "OK" : "Err";
        String temp = "" + this.showCandF(this.getTemperature());
        String v33 = this.d2StrV(this.getV33AuxFormula());
        String vvdd = this.d2StrV(this.getVvddFormula());
        String v12 = this.d2StrV(this.getV12Formula());
        String v18 = this.d2StrV(this.getV18Formula());
        String v33Aux = this.d2StrV(this.getV33AuxFormula());
        formatedString.append(String.format(formatTemplate, index, power, initial, vvdd, v33Aux, v12, v18, v33, temp));
        return formatedString.toString();
    }

    protected String showCandF(byte c) {
        if (c == -127) {
            return "N/A";
        }
        long f = Math.round(1.8 * (double)c + 32.0);
        return c + "C/" + f + "F";
    }

    public String d2StrV(double value) {
        int temp = (int)(value * 100.0);
        double d = (double)temp / 100.0;
        return "" + d + "V";
    }
}

