/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.cmtest;

import com.supermicro.ipmi.cmtest.IPMI;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CMServer {
    Map services;
    Set connections;
    int maxConnections;
    ThreadGroup threadGroup = new ThreadGroup(CMServer.class.getName());
    PrintWriter logStream;
    Logger logger;
    Level logLevel;

    public static void main(String[] args) {
        int port = 0;
        port = args.length < 2 ? 6666 : Integer.parseInt(args[1]);
        CMServer s = new CMServer(1000);
        IPMI ipmi = new IPMI();
        System.out.println("Server start at port :" + port + "Build: 061214");
        try {
            s.addService(ipmi, port);
        }
        catch (IOException ex) {
            System.out.println(ex.toString());
        }
    }

    public CMServer(OutputStream logStream, int maxConnections) {
        this(maxConnections);
        this.setLogStream(logStream);
        this.log("Starting server");
    }

    public CMServer(Logger logger, Level logLevel, int maxConnections) {
        this(maxConnections);
        this.setLogger(logger, logLevel);
        this.log("Starting server");
    }

    public CMServer(int maxConnections) {
        this.maxConnections = maxConnections;
        this.services = new HashMap();
        this.connections = new HashSet(maxConnections);
    }

    public synchronized void setLogStream(OutputStream out) {
        this.logStream = out != null ? new PrintWriter(out) : null;
    }

    public synchronized void setLogger(Logger logger, Level level) {
        this.logger = logger;
        this.logLevel = level;
    }

    protected synchronized void log(String s) {
        if (this.logger != null) {
            this.logger.log(this.logLevel, s);
        }
        if (this.logStream != null) {
            this.logStream.println("[" + new Date() + "] " + s);
            this.logStream.flush();
        }
    }

    protected void log(Object o) {
        this.log(o.toString());
    }

    public synchronized void addService(Service service, int port) throws IOException {
        Integer key = new Integer(port);
        if (this.services.get(key) != null) {
            throw new IllegalArgumentException("Port " + port + " already in use.");
        }
        Listener listener = new Listener(this.threadGroup, port, service);
        this.services.put(key, listener);
        this.log("Starting service " + service.getClass().getName() + " on port " + port);
        listener.start();
    }

    public synchronized void removeService(int port) {
        Integer key = new Integer(port);
        Listener listener = (Listener)this.services.get(key);
        if (listener == null) {
            return;
        }
        listener.pleaseStop();
        this.services.remove(key);
        this.log("Stopping service " + listener.service.getClass().getName() + " on port " + port);
    }

    protected synchronized void addConnection(Socket s, Service service) {
        if (this.connections.size() >= this.maxConnections) {
            try {
                PrintWriter out = new PrintWriter(s.getOutputStream());
                out.print("Connection refused; the server is busy; please try again later.\r\n");
                out.flush();
                s.close();
                this.log("Connection refused to " + s.getInetAddress().getHostAddress() + ":" + s.getPort() + ": max connections reached.");
            }
            catch (IOException e) {
                this.log(e);
            }
        } else {
            Connection c = new Connection(s, service);
            this.connections.add(c);
            this.log("Connected to " + s.getInetAddress().getHostAddress() + ":" + s.getPort() + " on port " + s.getLocalPort() + " for service " + service.getClass().getName());
            c.start();
        }
    }

    protected synchronized void endConnection(Connection c) {
        this.connections.remove(c);
        this.log("Connection to " + c.client.getInetAddress().getHostAddress() + ":" + c.client.getPort() + " closed.");
    }

    public synchronized void setMaxConnections(int max) {
        this.maxConnections = max;
    }

    public synchronized void displayStatus(PrintWriter out) {
        for (Integer port : this.services.keySet()) {
            Listener listener = (Listener)this.services.get(port);
            out.print("SERVICE " + listener.service.getClass().getName() + " ON PORT " + port + "\r\n");
        }
        out.print("MAX CONNECTIONS: " + this.maxConnections + "\r\n");
        for (Connection c : this.connections) {
            out.print("CONNECTED TO " + c.client.getInetAddress().getHostAddress() + ":" + c.client.getPort() + " ON PORT " + c.client.getLocalPort() + " FOR SERVICE " + c.service.getClass().getName() + "\r\n");
        }
    }

    public static class Control
    implements Service {
        CMServer server;
        String password;
        boolean connected = false;

        public Control(CMServer server, String password) {
            this.server = server;
            this.password = password;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void serve(InputStream i, OutputStream o) throws IOException {
            BufferedReader in = new BufferedReader(new InputStreamReader(i));
            PrintWriter out = new PrintWriter(o);
            boolean authorized = false;
            Control control = this;
            synchronized (control) {
                if (this.connected) {
                    out.print("ONLY ONE CONTROL CONNECTION ALLOWED.\r\n");
                    out.close();
                    return;
                }
                this.connected = true;
            }
            while (true) {
                out.print("> ");
                out.flush();
                String line = in.readLine();
                if (line == null) break;
                try {
                    StringTokenizer t = new StringTokenizer(line);
                    if (!t.hasMoreTokens()) continue;
                    String command = t.nextToken().toLowerCase();
                    if (command.equals("password")) {
                        String p = t.nextToken();
                        if (p.equals(this.password)) {
                            out.print("OK\r\n");
                            authorized = true;
                            continue;
                        }
                        out.print("INVALID PASSWORD\r\n");
                        continue;
                    }
                    if (command.equals("add")) {
                        Service service;
                        if (!authorized) {
                            out.print("PASSWORD REQUIRED\r\n");
                            continue;
                        }
                        String serviceName = t.nextToken();
                        Class<?> serviceClass = Class.forName(serviceName);
                        try {
                            service = (Service)serviceClass.newInstance();
                        }
                        catch (NoSuchMethodError e) {
                            throw new IllegalArgumentException("Service must have a no-argument constructor");
                        }
                        int port = Integer.parseInt(t.nextToken());
                        this.server.addService(service, port);
                        out.print("SERVICE ADDED\r\n");
                        continue;
                    }
                    if (command.equals("remove")) {
                        if (!authorized) {
                            out.print("PASSWORD REQUIRED\r\n");
                            continue;
                        }
                        int port = Integer.parseInt(t.nextToken());
                        this.server.removeService(port);
                        out.print("SERVICE REMOVED\r\n");
                        continue;
                    }
                    if (command.equals("max")) {
                        if (!authorized) {
                            out.print("PASSWORD REQUIRED\r\n");
                            continue;
                        }
                        int max = Integer.parseInt(t.nextToken());
                        this.server.setMaxConnections(max);
                        out.print("MAX CONNECTIONS CHANGED\r\n");
                        continue;
                    }
                    if (command.equals("status")) {
                        if (!authorized) {
                            out.print("PASSWORD REQUIRED\r\n");
                            continue;
                        }
                        this.server.displayStatus(out);
                        continue;
                    }
                    if (command.equals("help")) {
                        out.print("COMMANDS:\r\n\tpassword <password>\r\n\tadd <service> <port>\r\n\tremove <port>\r\n\tmax <max-connections>\r\n\tstatus\r\n\thelp\r\n\tquit\r\n");
                        continue;
                    }
                    if (command.equals("quit")) break;
                    out.print("UNRECOGNIZED COMMAND\r\n");
                }
                catch (Exception e) {
                    out.print("ERROR WHILE PARSING OR EXECUTING COMMAND:\r\n" + e + "\r\n");
                }
            }
            this.connected = false;
            out.close();
            in.close();
        }
    }

    public static class UniqueID
    implements Service {
        public int id = 0;

        public synchronized int nextId() {
            return this.id++;
        }

        public void serve(InputStream i, OutputStream o) throws IOException {
            PrintWriter out = new PrintWriter(o);
            out.print("You are client #: " + this.nextId() + "\r\n");
            out.close();
            i.close();
        }
    }

    public static class HTTPMirror
    implements Service {
        public void serve(InputStream i, OutputStream o) throws IOException {
            String line;
            BufferedReader in = new BufferedReader(new InputStreamReader(i));
            PrintWriter out = new PrintWriter(o);
            out.print("HTTP/1.0 200\r\n");
            out.print("Content-Type: text/plain\r\n\r\n");
            while ((line = in.readLine()) != null && line.length() != 0) {
                out.print(line + "\r\n");
            }
            out.close();
            in.close();
        }
    }

    public static class Reverse
    implements Service {
        public void serve(InputStream i, OutputStream o) throws IOException {
            BufferedReader in = new BufferedReader(new InputStreamReader(i));
            PrintWriter out = new PrintWriter(new BufferedWriter(new OutputStreamWriter(o)));
            out.print("Welcome to the line reversal server.\r\n");
            out.print("Enter lines.  End with a '.' on a line by itself.\r\n");
            while (true) {
                out.print("> ");
                out.flush();
                String line = in.readLine();
                if (line == null || line.equals(".")) break;
                for (int j = line.length() - 1; j >= 0; --j) {
                    out.print(line.charAt(j));
                }
                out.print("\r\n");
            }
            out.close();
            in.close();
        }
    }

    public static class Time
    implements Service {
        public void serve(InputStream i, OutputStream o) throws IOException {
            PrintWriter out = new PrintWriter(o);
            out.print(new Date() + "\r\n");
            out.close();
            i.close();
        }
    }

    public static interface Service {
        public void serve(InputStream var1, OutputStream var2) throws IOException;
    }

    public class Connection
    extends Thread {
        Socket client;
        Service service;

        public Connection(Socket client, Service service) {
            super("Server.Connection:" + client.getInetAddress().getHostAddress() + ":" + client.getPort());
            this.client = client;
            this.service = service;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                InputStream in = this.client.getInputStream();
                OutputStream out = this.client.getOutputStream();
                this.service.serve(in, out);
            }
            catch (IOException e) {
                CMServer.this.log(e);
            }
            finally {
                CMServer.this.endConnection(this);
            }
        }
    }

    public class Listener
    extends Thread {
        ServerSocket listen_socket;
        int port;
        Service service;
        volatile boolean stop;

        public Listener(ThreadGroup group, int port, Service service) throws IOException {
            super(group, "Listener:" + port);
            this.stop = false;
            this.listen_socket = new ServerSocket(port);
            this.listen_socket.setSoTimeout(5000);
            this.port = port;
            this.service = service;
        }

        public void pleaseStop() {
            this.stop = true;
            this.interrupt();
            try {
                this.listen_socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public void run() {
            while (!this.stop) {
                try {
                    Socket client = this.listen_socket.accept();
                    CMServer.this.addConnection(client, this.service);
                }
                catch (InterruptedIOException e) {
                }
                catch (IOException e) {
                    CMServer.this.log(e);
                }
            }
        }
    }
}

