/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMB;
import com.supermicro.ipmi.IPMILanCommand;
import com.supermicro.ipmi.blade.BladeEntity;
import com.supermicro.ipmi.blade.BladeSystemEntity;
import com.supermicro.ipmi.text.SuperBladeCommand;

public class BladeBMCIPSettingCommand
extends SuperBladeCommand {
    public boolean preValidate() {
        byte bladeIndex = Byte.parseByte((String)this.preParameters.get(1));
        if (bladeIndex < 1 || bladeIndex > 10) {
            System.out.println("blade Index out of range");
            return false;
        }
        return true;
    }

    public void runCommand() throws Exception {
        if (!this.isMaster) {
            this.printSlaveCMMUnavailableMessage();
            return;
        }
        BladeSystemEntity bladeSystem = new BladeSystemEntity(this.config, 10, 2, 2, 2, 4);
        bladeSystem.setEnableAllQuery(false);
        bladeSystem.setIsQueryBladeEntity(true);
        bladeSystem.getData();
        if (!bladeSystem.isLoginSuccessful) {
            System.out.println("Login error!");
            return;
        }
        byte bladeIndex = Byte.parseByte((String)this.preParameters.get(1));
        BladeEntity bladeEntity = bladeSystem.getBlades()[bladeIndex - 1];
        if (bladeEntity.getPresent() == 0) {
            System.out.println("Blade " + bladeIndex + " is not present");
            return;
        }
        if (bladeEntity.isSimCardDetectPin()) {
            if (this.parameters != null && this.parameters.length == 1) {
                String newIP = this.parameters[0];
                if (!IPMILanCommand.isIPAddress(newIP)) {
                    System.out.println("IP format error!");
                    return;
                }
                if (newIP.equals("0.0.0.0")) {
                    System.out.println("IP cannot be 0.0.0.0!");
                    return;
                }
                boolean b = this.writeSIMBLIP(newIP);
                if (b) {
                    System.out.println("done");
                } else {
                    System.out.println("failed");
                }
            } else if (bladeSystem.isIsSupportIPMB()) {
                this.showSIMBLIP();
            } else {
                System.out.println("BMC installed, but cannot get IP");
            }
        } else {
            System.out.println("BMC Not Installed");
        }
    }

    public void showSIMBLIP() {
        IPMILanCommand ipmiLanCommand = new IPMILanCommand(null);
        ipmiLanCommand.setIPMIInterface(this.ipmiCMMOEMCommand.getIPMIInterface());
        IPMB ipmb = new IPMB(ipmiLanCommand.getIPMIInterface());
        ipmiLanCommand.setIPMIInterface(ipmb);
        byte index = Byte.parseByte((String)this.preParameters.get(1));
        ipmb.setChannel(index);
        if (this.sessionController != null) {
            String ip = ipmiLanCommand.getIP();
            if (ip != null) {
                System.out.println(ip);
            } else {
                System.out.println("BMC Installed");
            }
        }
    }

    public boolean writeSIMBLIP(String ip) {
        IPMILanCommand ipmiLanCommand = new IPMILanCommand(null);
        IPMB ipmb = new IPMB(this.ipmiCMMOEMCommand.getIPMIInterface());
        ipmiLanCommand.setIPMIInterface(ipmb);
        byte index = Byte.parseByte((String)this.preParameters.get(1));
        ipmb.setChannel(index);
        boolean b = false;
        b = ipmiLanCommand.setIP(ip);
        return b;
    }
}

