/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.blade.BladeEntity;
import com.supermicro.ipmi.blade.BladeSystemEntity;
import com.supermicro.ipmi.text.SuperBladeCommand;

public class BladePowerCommand
extends SuperBladeCommand {
    public static final int ON = 0;
    public static final int OFF = 1;
    public static final int GRACEFULSHUTDOWN = 2;
    public static final int RESET = 3;
    public static final int NO_COMMAND = 99;
    private int subCommand = -1;

    public boolean preValidate() {
        boolean passValidate = false;
        byte bladeIndex = Byte.parseByte((String)this.preParameters.get(1));
        if (bladeIndex < 1 || bladeIndex > 10) {
            System.out.println("blade Index out of range");
            return false;
        }
        if (this.parameters != null) {
            if (this.parameters[0].equalsIgnoreCase("up")) {
                this.subCommand = 0;
                passValidate = true;
            } else if (this.parameters[0].equalsIgnoreCase("down")) {
                this.subCommand = 1;
                passValidate = true;
            } else if (this.parameters[0].equalsIgnoreCase("softshutdown")) {
                this.subCommand = 2;
                passValidate = true;
            } else if (this.parameters[0].equalsIgnoreCase("reset")) {
                this.subCommand = 3;
                passValidate = true;
            }
        } else {
            this.subCommand = 99;
            passValidate = true;
        }
        if (!passValidate) {
            this.printUsage();
            return false;
        }
        return true;
    }

    public void printUsage() {
        System.out.println("Available commands: up, down, softshutdown, reset");
    }

    public void runCommand() throws Exception {
        if (!this.isMaster) {
            this.printSlaveCMMUnavailableMessage();
            return;
        }
        byte bladeIndex = Byte.parseByte((String)this.preParameters.get(1));
        if (!this.isBladePresent(bladeIndex)) {
            System.out.println("Blade " + bladeIndex + " is not present");
            return;
        }
        switch (this.subCommand) {
            case 0: {
                int result = this.ipmiCMMOEMCommand.enableP12V(bladeIndex, (byte)1);
                if (result == 0) {
                    System.out.println("Done");
                    break;
                }
                if (result == 1) {
                    System.out.println("No enough power");
                    break;
                }
                System.out.println("Failed");
                break;
            }
            case 1: {
                int result = this.ipmiCMMOEMCommand.enableP12V(bladeIndex, (byte)0);
                if (result == 0) {
                    System.out.println("Done");
                    break;
                }
                if (result == 1) {
                    System.out.println("No enough power");
                    break;
                }
                System.out.println("Failed");
                break;
            }
            case 2: {
                boolean boolResult = this.ipmiCMMOEMCommand.gracefulPowerDownBlade(bladeIndex);
                if (boolResult) {
                    System.out.println("Done");
                    break;
                }
                System.out.println("Failed");
                break;
            }
            case 3: {
                boolean boolResult = this.ipmiCMMOEMCommand.resetBlade(bladeIndex);
                if (boolResult) {
                    System.out.println("Done");
                    break;
                }
                System.out.println("Failed");
                break;
            }
            case 99: {
                BladeSystemEntity bladeSystem = new BladeSystemEntity(this.config, 10, 2, 2, 2, 4);
                bladeSystem.setEnableAllQuery(false);
                bladeSystem.setIsQueryBladeEntity(true);
                bladeSystem.getData();
                bladeIndex = Byte.parseByte((String)this.preParameters.get(1));
                BladeEntity bladeEntity = bladeSystem.getBlades()[bladeIndex - 1];
                String power = bladeEntity.isV12vEnable() && bladeEntity.isV3_3v() ? "On" : "Off";
                System.out.println("Power: " + power);
                this.printUsage();
            }
        }
    }
}

