/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMILanCommand;
import com.supermicro.ipmi.text.SuperBladeCommand;

public class CMMGatewayCommand
extends SuperBladeCommand {
    public boolean preValidate() {
        byte cmmIndex = Byte.parseByte((String)this.preParameters.get(1));
        if (cmmIndex < 1 || cmmIndex > 2) {
            System.out.println("CMM Index out of range");
            return false;
        }
        return true;
    }

    public void runCommand() throws Exception {
        byte cmmIndex = Byte.parseByte((String)this.preParameters.get(1));
        if (!this.isConnectToCMM(cmmIndex - 1)) {
            System.out.println("This function is only available for the CMM connected");
            return;
        }
        IPMILanCommand ipmiLanCommand = new IPMILanCommand(null);
        ipmiLanCommand.setIPMIInterface(this.ipmiCMMOEMCommand.getIPMIInterface());
        if (this.parameters != null && this.parameters.length == 1) {
            String newGW = this.parameters[0];
            if (!IPMILanCommand.isIPAddress(newGW)) {
                System.out.println("Gateway format error!");
                return;
            }
            if (newGW.equals("0.0.0.0")) {
                System.out.println("Gateway cannot be 0.0.0.0!");
                return;
            }
            String oldGW = ipmiLanCommand.getGatewayIP();
            boolean result = ipmiLanCommand.setGatewayIP(newGW);
            if (result) {
                System.out.println("old Gateway:" + oldGW);
                System.out.println("new Gateway:" + newGW);
            } else {
                System.out.println(oldGW);
                System.out.println("Update Gateway failed");
            }
        } else {
            String gw = ipmiLanCommand.getGatewayIP();
            System.out.println(gw);
        }
    }
}

