/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.IPMILanCommand;
import com.supermicro.ipmi.text.SuperBladeCommand;

public class CMMNetmaskCommand
extends SuperBladeCommand {
    public boolean preValidate() {
        byte cmmIndex = Byte.parseByte((String)this.preParameters.get(1));
        if (cmmIndex < 1 || cmmIndex > 2) {
            System.out.println("CMM Index out of range");
            return false;
        }
        return true;
    }

    public void runCommand() throws Exception {
        byte cmmIndex = Byte.parseByte((String)this.preParameters.get(1));
        if (!this.isConnectToCMM(cmmIndex - 1)) {
            System.out.println("This function is only available for the CMM connected");
            return;
        }
        IPMILanCommand ipmiLanCommand = new IPMILanCommand(null);
        ipmiLanCommand.setIPMIInterface(this.ipmiCMMOEMCommand.getIPMIInterface());
        if (this.parameters != null && this.parameters.length == 1) {
            String mask = this.parameters[0];
            if (!IPMILanCommand.isIPAddress(mask)) {
                System.out.println("Netmask format error!");
                return;
            }
            if (mask.equals("0.0.0.0")) {
                System.out.println("Netmask cannot be 0.0.0.0!");
                return;
            }
            int intValue = ByteUtility.ipToInt(mask);
            if (((0 - intValue & intValue) - 1 | intValue) != -1) {
                System.out.println("Wrong netmask!");
                return;
            }
            String oldMask = ipmiLanCommand.getSubnetMask();
            boolean result = ipmiLanCommand.setSubnetMask(mask);
            if (result) {
                System.out.println("old Netmask:" + oldMask);
                System.out.println("new Netmask:" + mask);
            } else {
                System.out.println(oldMask);
                System.out.println("Update Netmask failed");
            }
        } else {
            String mask = ipmiLanCommand.getSubnetMask();
            System.out.println(mask);
        }
    }
}

