/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.text.Command;
import com.supermicro.ipmi.text.SuperBladeTool;
import java.util.StringTokenizer;

public class ChangeHostCommand
extends Command {
    String ip;
    String username;
    String password;

    public boolean preValidate() {
        boolean passValidate = false;
        if (this.parameters == null) {
            System.out.println("Current setting: ");
            System.out.println("IP       : " + this.config.getIp());
            System.out.println("Username : " + this.config.getUserName());
            System.out.println("Available command: IP [username] [password]");
            System.out.println("");
            System.out.println("Using wild card for IP");
            System.out.println("ex: 192.168.100.118 change to 192.168.100.9");
            System.out.println("    CMM>ch *.9");
            System.out.println("    192.168.100.9   change to 192.168.1.10");
            System.out.println("    CMM>ch *.1.10");
            System.out.println("");
            return false;
        }
        if (this.parameters.length >= 1) {
            this.ip = this.parameters[0];
            passValidate = true;
        }
        if (this.parameters.length >= 2) {
            this.username = this.parameters[1];
            passValidate = true;
        }
        if (this.parameters.length >= 3) {
            this.password = this.parameters[2];
            passValidate = true;
        }
        if (this.ip.startsWith("*")) {
            this.ip = this.replaceIP(this.ip);
        }
        if (this.ip != null && !SuperBladeTool.validateIP(this.ip)) {
            System.out.println("IP format erorr !");
            passValidate = false;
        }
        if (!passValidate) {
            System.out.println("Current setting: ");
            System.out.println("IP       : " + this.config.getIp());
            System.out.println("Username : " + this.config.getUserName());
            System.out.println("Available command: IP [username] [password]");
            return false;
        }
        byte[] guid = IPMIMessagingCommand.getSystemGUIDByIP(this.ip);
        if (guid == null) {
            System.out.println("cannot connect to " + this.ip);
            return false;
        }
        return true;
    }

    public String replaceIP(String newIP) {
        int foundIndex;
        String ip = this.config.getIp();
        String[] nip = new String[4];
        StringTokenizer st = new StringTokenizer(ip, ".");
        nip[0] = st.nextToken();
        nip[1] = st.nextToken();
        nip[2] = st.nextToken();
        nip[3] = st.nextToken();
        for (int i = 3; i > 0 && (foundIndex = newIP.lastIndexOf(".")) != -1; --i) {
            nip[i] = newIP.substring(foundIndex + 1, newIP.length());
            newIP = newIP.substring(0, foundIndex);
        }
        return "" + nip[0] + "." + nip[1] + "." + nip[2] + "." + nip[3];
    }

    public void execute() {
        boolean b = this.preValidate();
        if (!b) {
            return;
        }
        if (this.ip != null) {
            System.out.println("Old CMM IP   : " + this.config.getIp());
            this.config.setIp(this.ip);
            System.out.println("New CMM IP   : " + this.ip);
        }
        if (this.username != null) {
            System.out.println("Old Username : " + this.config.getUserName());
            this.config.setUserName(this.username);
            System.out.println("New Username : " + this.username);
        }
        if (this.password != null) {
            System.out.println("Old Password : " + this.config.getPassword());
            this.config.setPassword(this.password);
            System.out.println("New Password : " + this.password);
        }
        this.ip = null;
        this.username = null;
        this.password = null;
    }
}

