/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.text.Command;
import com.supermicro.ipmi.text.ShellCommand;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;

public class ExecCommand
extends Command {
    String filename;
    int loop = 1;
    int delay = 0;

    public void execute() {
        boolean result = this.preValidate();
        if (!result) {
            return;
        }
        ShellCommand shell = new ShellCommand();
        shell.setConfig(this.getConfig());
        shell.newParser();
        try {
            int count = 0;
            do {
                String line;
                BufferedReader in = new BufferedReader(new FileReader(this.filename));
                while ((line = in.readLine()) != null) {
                    if (line.length() == 0) continue;
                    System.out.println("EXEC[" + (count + 1) + "/" + this.loop + "][" + this.delay + "]>" + line);
                    shell.processCommand(line);
                    this.delay();
                }
            } while (++count != this.loop);
        }
        catch (FileNotFoundException ex) {
            System.out.println(ex.getMessage());
            return;
        }
        catch (IOException ex) {
            System.out.println(ex.getMessage());
            return;
        }
    }

    private void delay() {
        try {
            Thread.sleep(this.delay * 1000);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void initVariable() {
        this.loop = 1;
        this.delay = 0;
    }

    private boolean preValidate() {
        this.initVariable();
        if (this.parameters == null || this.parameters.length < 1) {
            System.out.println("Usage: exec <filename> [loop] [delay]");
            System.out.println("       loop = 0 infinite loop");
            System.out.println("       delay in second");
            return false;
        }
        if (this.parameters.length >= 1) {
            this.filename = this.parameters[0];
        }
        if (this.parameters.length >= 2) {
            try {
                this.loop = Integer.parseInt(this.parameters[1]);
            }
            catch (NumberFormatException ex) {
                System.out.println(ex.getMessage());
                return false;
            }
        }
        if (this.loop < 0) {
            System.out.println("loop cannot less then 0");
            return false;
        }
        if (this.parameters.length >= 3) {
            try {
                this.delay = Integer.parseInt(this.parameters[2]);
            }
            catch (NumberFormatException ex) {
                System.out.println(ex.getMessage());
                return false;
            }
        }
        if (this.delay < 0) {
            System.out.println("delay cannot less then 0");
            return false;
        }
        return true;
    }
}

