/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMILanCommand;
import com.supermicro.ipmi.IPMIPEFCommand;
import com.supermicro.ipmi.text.SuperBladeCommand;

public class IPMILanSNMPCommand
extends SuperBladeCommand {
    public void runCommand() throws Exception {
        IPMILanCommand ipmiLanCommand = new IPMILanCommand(this.ipmiCMMOEMCommand.getIPMIInterface());
        IPMIPEFCommand ipmiPEFCommand = new IPMIPEFCommand(this.ipmiCMMOEMCommand.getIPMIInterface());
        int destCount = ipmiLanCommand.getNumberOfDestination();
        if (this.parameters != null && (this.parameters.length == 2 || this.parameters.length == 3)) {
            boolean b;
            byte seq = 0;
            String seqStr = this.parameters[0];
            String ip = this.parameters[1];
            String mac = "00:00:00:00:00:00";
            if (this.parameters.length == 3) {
                mac = this.parameters[2];
            }
            try {
                seq = (byte)Integer.parseInt(seqStr);
            }
            catch (NumberFormatException ex) {
                System.out.println(" destination number format error!");
                return;
            }
            if (seq <= 0 || seq >= destCount) {
                System.out.println("destination number out of range. destiation size = " + destCount);
                return;
            }
            if (!IPMILanCommand.isIPAddress(ip)) {
                System.out.println("Netmask format error!");
                return;
            }
            if (ip.equals("0.0.0.0")) {
                System.out.println("Netmask cannot be 0.0.0.0!");
                return;
            }
            if (this.parameters.length == 3) {
                if (!IPMILanCommand.isMacAddress(mac)) {
                    System.out.println("MAC format error!");
                    return;
                }
                if (mac.equals("00:00:00:00:00:00")) {
                    System.out.println("MAC cannot be 00:00:00:00:00:00!");
                    return;
                }
            }
            byte policyNumber = 0;
            boolean b1 = ipmiPEFCommand.setDefaultEventFilterTableEntry((byte)1, policyNumber);
            boolean b2 = ipmiPEFCommand.setDefaultAlertPolicyTableEntry(seq, policyNumber, seq);
            boolean b3 = ipmiLanCommand.setDesitnationIPandMAC(seq, ip, mac);
            boolean b4 = ipmiLanCommand.setDefaultPEFDestinationType(seq);
            boolean bl = b = b1 && b2 && b3 && b4;
            if (b) {
                System.out.println("Done");
            } else {
                System.out.println("Fail");
            }
            this.printSNMPList(ipmiLanCommand, destCount);
        } else {
            this.printSNMPList(ipmiLanCommand, destCount);
        }
    }

    private void printSNMPList(IPMILanCommand ipmiLanCommand, int destCount) {
        String format = "%3s %20s %20s \n";
        System.out.printf(format, "Seq", "IP", "MAC");
        System.out.printf(format, "---", "--", "---");
        for (byte i = 1; i < destCount; i = (byte)(i + 1)) {
            String ip = ipmiLanCommand.getDestinationIP(i);
            String mac = ipmiLanCommand.getDestinationMAC(i);
            System.out.printf(format, i, ip, mac);
        }
    }
}

