/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.ACPIInfo;
import com.supermicro.ipmi.IPMIChassisCommand;
import com.supermicro.ipmi.IPMIGlobalCommand;
import com.supermicro.ipmi.text.SuperBladeCommand;

public class IPMIPowerCommand
extends SuperBladeCommand {
    public static final int ON = 0;
    public static final int OFF = 1;
    public static final int GRACEFULSHUTDOWN = 2;
    public static final int RESET = 3;
    public static final int CYCLE = 4;
    public static final int NO_COMMAND = 99;
    private int subCommand = -1;

    public boolean preValidate() {
        boolean passValidate = false;
        if (this.parameters != null) {
            if (this.parameters[0].equalsIgnoreCase("up")) {
                this.subCommand = 0;
                passValidate = true;
            } else if (this.parameters[0].equalsIgnoreCase("down")) {
                this.subCommand = 1;
                passValidate = true;
            } else if (this.parameters[0].equalsIgnoreCase("softshutdown")) {
                this.subCommand = 2;
                passValidate = true;
            } else if (this.parameters[0].equalsIgnoreCase("reset")) {
                this.subCommand = 3;
                passValidate = true;
            } else if (this.parameters[0].equalsIgnoreCase("cycle")) {
                this.subCommand = 4;
                passValidate = true;
            }
        } else {
            this.subCommand = 99;
            passValidate = true;
        }
        if (!passValidate) {
            this.printUsage();
            return false;
        }
        return true;
    }

    public void printUsage() {
        System.out.println("Available commands: up, down, softshutdown, reset, cycle");
    }

    public void runCommand() throws Exception {
        IPMIChassisCommand ipmiChassisCommand = new IPMIChassisCommand(this.ipmiCMMOEMCommand.getIPMIInterface());
        IPMIGlobalCommand ipmiGlobalCommand = new IPMIGlobalCommand(this.ipmiCMMOEMCommand.getIPMIInterface());
        switch (this.subCommand) {
            case 0: {
                boolean boolResult = ipmiChassisCommand.powerUp();
                if (boolResult) {
                    System.out.println("Done");
                    break;
                }
                System.out.println("Failed");
                break;
            }
            case 1: {
                boolean boolResult = ipmiChassisCommand.powerDown();
                if (boolResult) {
                    System.out.println("Done");
                    break;
                }
                System.out.println("Failed");
                break;
            }
            case 2: {
                boolean boolResult = ipmiChassisCommand.softShutdown();
                if (boolResult) {
                    System.out.println("Done");
                    break;
                }
                System.out.println("Failed");
                break;
            }
            case 3: {
                boolean boolResult = ipmiChassisCommand.reset();
                if (boolResult) {
                    System.out.println("Done");
                    break;
                }
                System.out.println("Failed");
                break;
            }
            case 4: {
                boolean boolResult = ipmiChassisCommand.powerCycle();
                if (boolResult) {
                    System.out.println("Done");
                    break;
                }
                System.out.println("Failed");
                break;
            }
            case 99: {
                ACPIInfo acpi = ipmiGlobalCommand.getACPI();
                System.out.println("ACPI Power Status: " + acpi.getSystemStateInfo() + " (" + acpi.getSystemStateDescription() + ")");
                this.printUsage();
            }
        }
    }
}

