/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.GlobalDefine;
import com.supermicro.ipmi.IPMIMessage;
import com.supermicro.ipmi.text.SuperBladeCommand;

public class IPMIRawCommand
extends SuperBladeCommand {
    public void runCommand() throws Exception {
        byte[] data;
        byte cmd;
        byte netfn;
        if (this.parameters == null || this.parameters.length < 2) {
            System.out.println("<netFn> <cmd> [data] parameters required. netFn needs shift 2 bit");
            return;
        }
        try {
            netfn = (byte)Integer.parseInt(this.parameters[0], 16);
            cmd = (byte)Integer.parseInt(this.parameters[1], 16);
            int dataSize = this.parameters.length - 2;
            data = new byte[dataSize];
            for (int i = 0; i < dataSize; ++i) {
                data[i] = (byte)Integer.parseInt(this.parameters[2 + i], 16);
            }
        }
        catch (NumberFormatException ex) {
            System.out.println(ex.getMessage());
            return;
        }
        IPMIMessage ipmiMessage = new IPMIMessage();
        ipmiMessage.setCommandAndData(netfn, cmd, data);
        IPMIMessage resMessage = this.ipmiCMMOEMCommand.getIPMIInterface().send(ipmiMessage);
        if (resMessage != null) {
            System.out.println("Completion code = " + ByteUtility.byteToHex(resMessage.completionCode) + "h");
            if (resMessage.completionCode != 0) {
                System.out.println("(" + GlobalDefine.getCompletionCodeString(resMessage.completionCode) + ")");
            }
            if (resMessage.data != null && resMessage.data.length != 0) {
                System.out.println("Return data = " + ByteUtility.bytesToHex(resMessage.data));
            }
        }
    }
}

