/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.text.SuperBladeCommand;

public class InfinibandPowerCommand
extends SuperBladeCommand {
    public static final int ON = 0;
    public static final int OFF = 1;
    public static final int RESET = 2;
    private int subCommand = -1;

    public boolean preValidate() {
        boolean passValidate = false;
        byte ibIndex = Byte.parseByte((String)this.preParameters.get(1));
        if (ibIndex < 1 || ibIndex > 2) {
            System.out.println("Infiniband Index out of range");
            return false;
        }
        if (this.parameters != null) {
            if (this.parameters[0].equalsIgnoreCase("on")) {
                this.subCommand = 0;
                passValidate = true;
            } else if (this.parameters[0].equalsIgnoreCase("off")) {
                this.subCommand = 1;
                passValidate = true;
            } else if (this.parameters[0].equalsIgnoreCase("reset")) {
                this.subCommand = 2;
                passValidate = true;
            }
        }
        if (!passValidate) {
            System.out.println("Available command: on,off,reset");
            return false;
        }
        return true;
    }

    public void runCommand() throws Exception {
        if (!this.isMaster) {
            this.printSlaveCMMUnavailableMessage();
            return;
        }
        byte ibIndex = Byte.parseByte((String)this.preParameters.get(1));
        if (!this.isIBPresent(ibIndex)) {
            System.out.println("Infiniband " + ibIndex + " is not present");
            return;
        }
        switch (this.subCommand) {
            case 0: {
                boolean boolResult = this.ipmiCMMOEMCommand.enableInfinibandPower(ibIndex, (byte)1);
                if (boolResult) {
                    System.out.println("Done");
                    break;
                }
                System.out.println("Failed");
                break;
            }
            case 1: {
                boolean boolResult = this.ipmiCMMOEMCommand.enableInfinibandPower(ibIndex, (byte)0);
                if (boolResult) {
                    System.out.println("Done");
                    break;
                }
                System.out.println("Failed");
                break;
            }
            case 2: {
                boolean boolResult = this.ipmiCMMOEMCommand.resetInfiniband(ibIndex);
                if (boolResult) {
                    System.out.println("Done");
                    break;
                }
                System.out.println("Failed");
            }
        }
    }
}

