/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.blade.BladeSystemEntity;
import com.supermicro.ipmi.blade.PowerSupplyEntity;
import com.supermicro.ipmi.text.SuperBladeCommand;

public class PowerSupplyStatusCommand
extends SuperBladeCommand {
    public boolean preValidate() {
        byte powerIndex = Byte.parseByte((String)this.preParameters.get(1));
        if (powerIndex < 1 || powerIndex > 4) {
            System.out.println("Power Supply Index out of range");
            return false;
        }
        return true;
    }

    public void runCommand() throws Exception {
        if (!this.isMaster) {
            this.printSlaveCMMUnavailableMessage();
            return;
        }
        BladeSystemEntity bladeSystem = new BladeSystemEntity(this.config, 10, 2, 2, 2, 4);
        bladeSystem.setEnableAllQuery(false);
        bladeSystem.setIsQueryPowerSupplyEntity(true);
        bladeSystem.getData();
        if (!bladeSystem.isLoginSuccessful) {
            System.out.println("Login error!");
            return;
        }
        byte index = Byte.parseByte((String)this.preParameters.get(1));
        PowerSupplyEntity ps = bladeSystem.getPowerSupplies()[index - 1];
        if (ps.getPresent() == 0) {
            System.out.println("Power Supply " + index + " is not present");
            return;
        }
        System.out.print(ps.toFormatedHeader());
        System.out.print(ps.toFormatedString());
    }
}

