/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMINetworkInterface;
import com.supermicro.ipmi.SOLSessionController;
import com.supermicro.ipmi.sol.SOLPacketSender;
import com.supermicro.ipmi.sol.Storage;
import com.supermicro.ipmi.text.Command;
import java.util.HashMap;
import java.util.Observable;
import java.util.Observer;
import jcurses.system.InputChar;
import jcurses.system.Toolkit;

public class SOLStartCommand
extends Command
implements Observer {
    Storage storage;
    SOLSessionController solSessionController;
    SOLPacketSender solPacketSender;
    HashMap javaKeyCodeToSOLKeyCode = new HashMap();

    public SOLStartCommand() {
        this.javaKeyCodeToSOLKeyCode.put("" + InputChar.KEY_UP, new byte[]{27, 91, 65});
        this.javaKeyCodeToSOLKeyCode.put("" + InputChar.KEY_DOWN, new byte[]{27, 91, 66});
        this.javaKeyCodeToSOLKeyCode.put("" + InputChar.KEY_LEFT, new byte[]{27, 91, 68});
        this.javaKeyCodeToSOLKeyCode.put("" + InputChar.KEY_RIGHT, new byte[]{27, 91, 67});
        this.javaKeyCodeToSOLKeyCode.put("10", new byte[]{13});
        this.javaKeyCodeToSOLKeyCode.put("" + InputChar.KEY_F1, new byte[]{27, 49});
        this.javaKeyCodeToSOLKeyCode.put("" + InputChar.KEY_F2, new byte[]{27, 50});
        this.javaKeyCodeToSOLKeyCode.put("" + InputChar.KEY_F3, new byte[]{27, 51});
        this.javaKeyCodeToSOLKeyCode.put("" + InputChar.KEY_F4, new byte[]{27, 52});
        this.javaKeyCodeToSOLKeyCode.put("" + InputChar.KEY_F5, new byte[]{27, 53});
        this.javaKeyCodeToSOLKeyCode.put("" + InputChar.KEY_F6, new byte[]{27, 54});
        this.javaKeyCodeToSOLKeyCode.put("" + InputChar.KEY_F7, new byte[]{27, 55});
        this.javaKeyCodeToSOLKeyCode.put("" + InputChar.KEY_F8, new byte[]{27, 56});
        this.javaKeyCodeToSOLKeyCode.put("" + InputChar.KEY_F9, new byte[]{27, 57});
        this.javaKeyCodeToSOLKeyCode.put("" + InputChar.KEY_F10, new byte[]{27, 48});
        this.javaKeyCodeToSOLKeyCode.put("" + InputChar.KEY_F11, new byte[]{27, 33});
        this.javaKeyCodeToSOLKeyCode.put("" + InputChar.KEY_F12, new byte[]{27, 64});
        this.javaKeyCodeToSOLKeyCode.put("" + InputChar.KEY_IC, new byte[]{27, 91, 50, 126});
        this.javaKeyCodeToSOLKeyCode.put("" + InputChar.KEY_DC, new byte[]{27, 91, 51, 126});
        this.javaKeyCodeToSOLKeyCode.put("" + InputChar.KEY_HOME, new byte[]{27, 91, 49, 126});
        this.javaKeyCodeToSOLKeyCode.put("" + InputChar.KEY_END, new byte[]{27, 91, 52, 126});
        this.javaKeyCodeToSOLKeyCode.put("" + InputChar.KEY_PPAGE, new byte[]{27, 91, 53, 126});
        this.javaKeyCodeToSOLKeyCode.put("" + InputChar.KEY_NPAGE, new byte[]{27, 91, 54, 126});
        this.javaKeyCodeToSOLKeyCode.put("263", new byte[]{8});
    }

    public void execute() {
        this.solSessionController = new SOLSessionController();
        this.storage = new Storage();
        IPMINetworkInterface ipmiInterface = this.solSessionController.startup(this.config);
        if (this.solSessionController.isSOLActivated) {
            System.out.println("sol start OK");
            this.storage.reset();
            this.solPacketSender = new SOLPacketSender(this.storage, this.solSessionController);
            this.solPacketSender.start();
            ipmiInterface.addObserver(this.solSessionController);
            ipmiInterface.addObserver(this);
            this.clearScreen();
            this.getInput();
            return;
        }
        System.out.println("sol start failed");
        if (ipmiInterface != null) {
            this.solSessionController.closeSession();
        }
    }

    public void update(Observable o, Object arg) {
        if (arg instanceof byte[]) {
            byte[] screenData = (byte[])arg;
            for (int i = 0; i < screenData.length; ++i) {
                System.out.print((char)screenData[i]);
            }
        }
    }

    public void getInput() {
        block2: {
            InputChar c;
            do {
                c = Toolkit.readCharacter();
                byte[] keycode = (byte[])this.javaKeyCodeToSOLKeyCode.get("" + c.getCode());
                if (keycode != null) {
                    this.storage.puts(keycode);
                    continue;
                }
                this.storage.put((byte)c.getCode());
            } while (c.getCode() != InputChar.KEY_F12);
            System.out.println("outoutout");
            if (this.solSessionController == null) break block2;
            this.solSessionController.closeSession();
        }
    }

    public void clearScreen() {
        System.out.print('\u001b');
        System.out.println("[2J");
    }
}

