/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.text.Command;
import com.supermicro.ipmi.text.Parser;
import com.supermicro.ipmi.text.SuperBladeCommand;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ShellCommand
extends SuperBladeCommand {
    Calendar startTime;
    Parser parser;
    ArrayList commandHistory = new ArrayList();
    int commandHistoryIndex = 0;

    public ShellCommand() {
        this.startTime = Calendar.getInstance();
    }

    public void runCommand() {
    }

    public void execute() {
        System.out.println("Press Ctrl+C or \"exit\" to exit");
        System.out.println("Press \"?\" or \"help\" for help");
        System.out.println("Press \"/\" for command history");
        System.out.println("Press \"\\<#>\" for command history execution");
        BufferedReader from_user = new BufferedReader(new InputStreamReader(System.in));
        while (true) {
            this.printPrompt();
            String line = null;
            try {
                line = from_user.readLine();
            }
            catch (IOException ex1) {
                // empty catch block
            }
            if (this.parser == null) {
                this.newParser();
            }
            if (line == null || line.trim().equalsIgnoreCase("exit")) break;
            if (line.trim().equals("/")) {
                this.printCommandHistory();
                continue;
            }
            if (line.trim().startsWith("\\")) {
                line = this.lastCommand(line);
            }
            if (line.trim().equalsIgnoreCase("help") || line.trim().equalsIgnoreCase("?")) {
                this.parser.helpPrintAvailableCommand(this.parser.argumentRoot);
                this.printRuntimeAndHelp();
                continue;
            }
            try {
                this.processCommand(line);
            }
            catch (Exception ex) {
                System.out.println(ex.getMessage());
            }
        }
        System.out.println("bye");
    }

    public void newParser() {
        this.parser = new Parser(true);
    }

    private void printPrompt() {
        byte[] guid = IPMIMessagingCommand.getSystemGUIDByIP(this.config.getIp());
        if (guid == null) {
            System.out.print(">");
        } else if (IPMIMessagingCommand.isCMMGUID(guid)) {
            System.out.print("CMM>");
        } else if (IPMIMessagingCommand.isPepperconGUID(guid)) {
            System.out.print("SIM-KVM-IPMI>");
        } else if (IPMIMessagingCommand.isPepperconNoneKVMGUID(guid)) {
            System.out.print("SIM-IPMI>");
        } else if (IPMIMessagingCommand.isSIMBL(guid)) {
            System.out.print("SIMBL>");
        } else if (IPMIMessagingCommand.isOSAGUID(guid)) {
            System.out.print("IPMI>");
        }
    }

    private String lastCommand(String line) {
        int numberInt;
        if (this.commandHistory.size() == 0) {
            return "";
        }
        String numberStr = line.substring(1);
        try {
            numberInt = Integer.parseInt(numberStr);
        }
        catch (NumberFormatException ex1) {
            System.out.println("number parse error!");
            return "";
        }
        this.commandHistoryIndex = numberInt;
        if (this.commandHistoryIndex <= 0) {
            return "";
        }
        if (this.commandHistory.size() - this.commandHistoryIndex < 0) {
            return "";
        }
        line = (String)this.commandHistory.get(this.commandHistory.size() - this.commandHistoryIndex);
        System.out.println(line);
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        return line;
    }

    private void printRuntimeAndHelp() {
        String usedMemory = (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 1024L + "K";
        String freeMemory = Runtime.getRuntime().freeMemory() / 1024L + "K";
        String totalMemory = Runtime.getRuntime().totalMemory() / 1024L + "K";
        String maxMemory = Runtime.getRuntime().maxMemory() / 1024L + "K";
        String maxAvailableMemory = (Runtime.getRuntime().maxMemory() - (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory())) / 1024L + "K";
        SimpleDateFormat f = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        System.out.println("Runtime Info:");
        System.out.printf("%-20s \t %-20s \n", "Host IP", this.config.getIp());
        System.out.printf("%-20s \t %-20s \n", "Username", this.config.getUserName());
        System.out.printf("%-20s \t %-20s \n", "Java Version", System.getProperty("java.vm.version"));
        System.out.printf("%-20s \t %-20s \n", "Used Memory", usedMemory);
        System.out.printf("%-20s \t %-20s \n", "Free Memory", freeMemory);
        System.out.printf("%-20s \t %-20s \n", "Total Memory", totalMemory);
        System.out.printf("%-20s \t %-20s \n", "Max Memory", maxMemory);
        System.out.printf("%-20s \t %-20s \n", "Max available Memory", maxAvailableMemory);
        System.out.printf("%-20s \t %-20s \n", "StartTime", f.format(this.startTime.getTime()));
        System.out.printf("%-20s \t %-20s \n", "Current Time", f.format(Calendar.getInstance().getTime()));
        System.out.printf("%-20s \t %-20s \n", "Time elapsed", ShellCommand.timeDiff(this.startTime, Calendar.getInstance()));
        System.out.println("");
        System.out.println("Press Ctrl+C or \"exit\" to exit");
        System.out.println("Press \"?\" or \"help\" for help");
        System.out.println("Press \"/\" for command history");
        System.out.println("Press \"\\<#>\" for command history execution");
    }

    public static String timeDiff(Calendar c1, Calendar c2) {
        long diffMillis = c2.getTimeInMillis() - c1.getTimeInMillis();
        long diffSecs = diffMillis / 1000L;
        long diffMins = diffMillis / 60000L;
        long diffHours = diffMillis / 3600000L;
        long diffDays = diffMillis / 86400000L;
        long leafHours = diffMillis % 86400000L / 3600000L;
        long leafMins = diffMillis % 86400000L % 3600000L / 60000L;
        return "" + diffDays + "d" + " " + leafHours + "h" + " " + leafMins + "m";
    }

    public void processCommand(String commandLine) {
        if (commandLine.length() == 0) {
            return;
        }
        ArrayList<String> string = new ArrayList<String>();
        Pattern p = Pattern.compile("\".*?\"|\\S+");
        Matcher m = p.matcher(commandLine);
        while (m.find()) {
            String token = m.group();
            if (token.startsWith("\"") && token.endsWith("\"")) {
                token = token.substring(1, token.length() - 1);
            }
            string.add(token);
        }
        String[] args = new String[string.size()];
        string.toArray(args);
        this.parser.argumentRoot.clearValue();
        Command command = this.parser.parse(this.parser.argumentRoot, args);
        if (command == null) {
            return;
        }
        try {
            command.setConfig(this.config);
            command.setOriginalParser(this.parser);
            command.execute();
            System.out.println("");
            this.commandHistory.add(commandLine);
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
    }

    public void printCommandHistory() {
        if (this.commandHistory.size() == 0) {
            System.out.println("Command history empty");
            return;
        }
        System.out.println("Command History:");
        for (int i = 0; i < this.commandHistory.size(); ++i) {
            System.out.printf("(%2d) %-20s \t : %s \n", i + 1, "\\" + (i + 1), this.commandHistory.get(this.commandHistory.size() - i - 1));
            if (i == 19) break;
        }
    }

    private String multiSlash(int n) {
        String slash = "";
        for (int i = 0; i < n; ++i) {
            slash = slash + "\\";
        }
        return slash;
    }

    public static void main(String[] args) {
        String a = "1 2 3 4 \"asdf asd fasdfa sdf\" ";
        Pattern p = Pattern.compile("\".*?\"|\\S+");
        Matcher m = p.matcher(a);
        while (m.find()) {
            String token = m.group();
            if (token.startsWith("\"") && token.endsWith("\"")) {
                token = token.substring(1, token.length() - 1);
            }
            System.out.println(token);
        }
    }
}

