/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.text.SuperBladeCommand;

public class UserAddCommand
extends SuperBladeCommand {
    byte userID;
    String username;
    String password;
    byte privilege;

    public boolean preValidate() {
        String usage = "Usage: user add <user id> <user name> <password> <privilege> \nFor privilege level:\nAdministrator level : 4\nOperator level      : 3\nUser level          : 2\nCallback            : 1";
        if (this.parameters == null || this.parameters.length != 4) {
            System.out.println(usage);
            return false;
        }
        try {
            this.userID = Byte.parseByte(this.parameters[0]);
        }
        catch (NumberFormatException ex) {
            System.out.println("user id should be number");
            System.out.println(usage);
            return false;
        }
        this.username = this.parameters[1];
        if (this.username.length() > 20) {
            System.out.println("username should less then 20 characters");
            System.out.println(usage);
            return false;
        }
        this.password = this.parameters[2];
        if (this.password.length() > 20) {
            System.out.println("password should less then 20 characters");
            System.out.println(usage);
            return false;
        }
        try {
            this.privilege = Byte.parseByte(this.parameters[3]);
        }
        catch (NumberFormatException ex) {
            System.out.println("privilege should be number");
            System.out.println(usage);
            return false;
        }
        if (this.privilege < 1 || this.privilege > 4) {
            System.out.println("Privilege level error");
            System.out.println("Administrator level : 4");
            System.out.println("operator level      : 3");
            System.out.println("user level          : 2");
            System.out.println("callback            : 1");
            return false;
        }
        return true;
    }

    public void runCommand() throws Exception {
        IPMIMessagingCommand ipmiMessagingCommand = new IPMIMessagingCommand(null);
        ipmiMessagingCommand.setIPMIInterface(this.ipmiCMMOEMCommand.getIPMIInterface());
        boolean b1 = ipmiMessagingCommand.setUserNameByID(this.userID, this.username);
        if (!b1) {
            System.out.println("Set user name failed");
            return;
        }
        boolean b2 = ipmiMessagingCommand.setUserPasswordByID(this.userID, this.password);
        if (!b2) {
            System.out.println("Set user password failed");
            return;
        }
        boolean b3 = ipmiMessagingCommand.setEnableUserByID(this.userID);
        if (!b3) {
            System.out.println("Set enable user failed");
            return;
        }
        boolean b4 = ipmiMessagingCommand.setUserPrivilegeByID(this.userID, this.privilege);
        if (!b4) {
            System.out.println("Set user privilege failed");
            return;
        }
        boolean b5 = ipmiMessagingCommand.setEnableUserPlusByID(this.userID, this.privilege);
        if (!b5) {
            System.out.println("Set enable user(+) failed");
            return;
        }
        System.out.println("done");
    }
}

