/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMIMessage;
import com.supermicro.ipmi.IPMIRaritanOEMCommand;
import com.supermicro.ipmi.text.SuperBladeCommand;

public class VMStopCommand
extends SuperBladeCommand {
    byte driveID;

    public boolean preValidate() {
        String usage = "Usage: vm stop <drive ID>\ndrive ID = <1|2>";
        if (this.parameters == null || this.parameters.length != 1) {
            System.out.println(usage);
            return false;
        }
        try {
            this.driveID = Byte.parseByte(this.parameters[0]);
        }
        catch (NumberFormatException ex) {
            System.out.println("drive ID should be number");
            System.out.println(usage);
            return false;
        }
        if (this.driveID < 1 || this.driveID > 2) {
            System.out.println(usage);
            return false;
        }
        return true;
    }

    public void runCommand() throws Exception {
        if (!this.isMaster) {
            this.printSlaveCMMUnavailableMessage();
            return;
        }
        IPMIRaritanOEMCommand ipmiRaritanOEMCommand = new IPMIRaritanOEMCommand(null);
        ipmiRaritanOEMCommand.setIPMIInterface(this.ipmiCMMOEMCommand.getIPMIInterface());
        IPMIMessage resMessage = ipmiRaritanOEMCommand.closeVirtualMediaSession(this.driveID);
        if (resMessage != null && resMessage.completionCode == 0) {
            System.out.println("done");
            return;
        }
        System.out.println("fail");
    }
}

