/*
 * Decompiled with CFR 0.152.
 */
package nn.pp.rc;

import java.awt.BorderLayout;
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Point;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.URL;
import nn.pp.rc.RFBproto;
import nn.pp.rc.T;

public class ChatFrame {
    private TextArea chatarea;
    private TextField chatline;
    private Label idlabel;
    private Checkbox beep;
    private Component parent;
    private PrintStream logger;
    private Dialog myFrame;
    private RFBproto proto;
    private String me;
    private URL codebase;
    private static final String NASTRING = "unknown";

    public ChatFrame(Component parent, PrintStream logger, URL codebase) {
        this.parent = parent;
        this.logger = logger;
        this.codebase = codebase;
    }

    public Window getAsWindow() {
        if (this.myFrame == null) {
            this.chatline = new TextField(40);
            this.chatline.addActionListener(new ChatHandler());
            this.chatarea = new TextArea("", 10, 60, 1);
            this.chatarea.setEditable(false);
            this.chatarea.setBackground(this.chatline.getBackground());
            Panel clp = new Panel();
            clp.setLayout(new BorderLayout());
            this.idlabel = new Label(this.getIdLabel());
            this.beep = new Checkbox("Beep", false);
            clp.add((Component)this.idlabel, "West");
            clp.add((Component)this.chatline, "Center");
            clp.add((Component)this.beep, "East");
            while (!(this.parent instanceof Frame) && null != (this.parent = this.parent.getParent())) {
            }
            this.myFrame = new Dialog((Frame)this.parent);
            this.myFrame.setLayout(new BorderLayout());
            this.myFrame.add((Component)this.chatarea, "Center");
            this.myFrame.add((Component)clp, "South");
            this.myFrame.setTitle(this.getFrameTitle());
            this.myFrame.pack();
            this.myFrame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent e) {
                    ChatFrame.this.setVisible(false);
                }
            });
        }
        return this.myFrame;
    }

    public void setRFBProto(RFBproto proto) {
        this.proto = proto;
        if (null != this.myFrame) {
            this.idlabel.setText(this.getIdLabel());
            this.myFrame.setTitle(this.getFrameTitle());
        }
    }

    public void setVisible(boolean v) {
        Window win = this.getAsWindow();
        if (v && !win.isShowing()) {
            Point p = this.parent.getLocationOnScreen();
            Dimension pdim = this.parent.getSize();
            Dimension cdim = win.getSize();
            int x = pdim.width - cdim.width;
            int y = pdim.height - cdim.height;
            p.translate(x, y);
            win.setLocation(p);
        }
        if (v) {
            if (!win.isVisible()) {
                win.setVisible(v);
            }
        } else {
            win.setVisible(v);
            win.dispose();
        }
    }

    public void newMsg(String msg) {
        this.setVisible(true);
        this.chatarea.append(msg + '\n');
        this.chatarea.setCaretPosition(this.chatarea.getText().length() + 8192);
        if (this.beep.getState()) {
            Toolkit.getDefaultToolkit().beep();
        }
        this.chatline.requestFocus();
    }

    public void close() {
        if (this.myFrame != null) {
            this.myFrame.setVisible(false);
            this.myFrame.dispose();
        }
    }

    private String getIdLabel() {
        if (null == this.me || this.me.equals(NASTRING)) {
            try {
                this.me = InetAddress.getLocalHost().getHostName();
                if (this.me.equals("localhost")) {
                    this.me = this.toughGetHostName();
                }
            }
            catch (Exception e) {
                this.me = this.toughGetHostName();
            }
        }
        String n = this.proto == null ? NASTRING : this.proto.name;
        String u = null;
        try {
            u = System.getProperty("user.name") + '@';
        }
        catch (Exception e) {
            u = "";
        }
        return u + this.me + "(" + n + ")";
    }

    private String toughGetHostName() {
        String n = null;
        Socket s = null;
        try {
            String host = this.codebase.getHost();
            int port = this.codebase.getPort();
            if (port < 0) {
                String protocol = this.codebase.getProtocol();
                port = protocol.equals("https") ? 443 : 80;
            }
            s = new Socket(host, port);
            n = s.getLocalAddress().getHostName();
            s.close();
        }
        catch (Exception e) {
            String msg = e.getMessage();
            int i1 = msg.indexOf(34);
            if (i1 >= 0) {
                n = msg.substring(i1 + 1, msg.lastIndexOf(34));
            }
            System.out.println("ERROR: no local hostname: " + e);
            n = NASTRING;
        }
        if (s != null) {
            try {
                s.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return n;
    }

    private String getFrameTitle() {
        String a = this.proto == null ? T._("not connected") : this.proto.profile.remoteHost;
        return a + " Chat";
    }

    class ChatHandler
    implements ActionListener {
        ChatHandler() {
        }

        public void actionPerformed(ActionEvent e) {
            if (null != ChatFrame.this.proto) {
                try {
                    ChatFrame.this.proto.writeString(ChatFrame.this.idlabel.getText() + "=> " + ChatFrame.this.chatline.getText());
                    ChatFrame.this.chatline.setText("");
                }
                catch (IOException ex) {
                    ChatFrame.this.logger.println(T._("WARNING: Chat:") + " " + ex);
                }
            } else {
                ChatFrame.this.logger.println(T._("WARNING: Chat not connected!"));
            }
        }
    }
}

