/*
 * Decompiled with CFR 0.152.
 */
package nn.pp.rc;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import nn.pp.rc.T;
import nn.pp.rc.TimerQueue;

public class GenericTimer
implements Serializable {
    protected ActionListener actionListener;
    int delay;
    boolean repeats = true;
    long expirationTime;
    GenericTimer nextTimer;
    boolean running;
    boolean notify;

    public GenericTimer(int delay, ActionListener listener) {
        this.delay = delay;
        this.actionListener = listener;
    }

    TimerQueue timerQueue() {
        return TimerQueue.sharedInstance();
    }

    public void setDelay(int delay) {
        if (delay < 0) {
            throw new IllegalArgumentException(T._("Invalid delay:") + " " + delay);
        }
        this.delay = delay;
    }

    public int getDelay() {
        return this.delay;
    }

    public void setRepeats(boolean flag) {
        this.repeats = flag;
    }

    public boolean isRepeats() {
        return this.repeats;
    }

    public boolean isRunning() {
        return this.timerQueue().containsTimer(this);
    }

    public void start() {
        this.notify = true;
        this.timerQueue().addTimer(this, System.currentTimeMillis() + (long)this.getDelay());
    }

    public void stop() {
        this.timerQueue().removeTimer(this);
        this.repeats = false;
        this.notify = false;
    }

    synchronized void post() {
        if (this.notify) {
            this.actionListener.actionPerformed(new ActionEvent(this, 0, ""));
        }
    }
}

