/*
 * Decompiled with CFR 0.152.
 */
package nn.pp.rc;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageObserver;
import java.awt.image.RGBImageFilter;
import java.util.Enumeration;
import java.util.Vector;

public class ImageButton
extends Canvas
implements MouseListener,
ImageObserver {
    private Dimension dimSize;
    private Dimension dimRealSize;
    private Dimension imageSize;
    private Image image = null;
    private Image grayImage = null;
    private String label = null;
    private int imageIndex;
    private byte state;
    private byte oldstate;
    private Color colHlNorm;
    private Color colHlHl;
    private Color colShd;
    private Color colHlShd;
    private Color colFg;
    private Color colBg;
    private Font fontLabel;
    private FontMetrics fontMetrics;
    private Image offscreenImage = null;
    private boolean active = true;
    private transient Vector alisteners = null;
    private transient Vector mlisteners = null;
    private boolean alwaysInactive = false;
    static final byte StateNormal = 0;
    static final byte StateHighlight = 1;
    static final byte StatePressed = 2;
    private int darkness = -5263441;

    public ImageButton(String label) {
        this.label = label;
        this.state = 0;
        this.setDefaultValues();
        this.addMouseListener(this);
        this.dimRealSize = new Dimension(0, 0);
    }

    public ImageButton(Image image, Dimension imageSize, int imageIndex) {
        this.image = image;
        this.imageSize = imageSize;
        this.imageIndex = imageIndex;
        this.setDefaultValues();
        this.addMouseListener(this);
        this.dimRealSize = new Dimension(0, 0);
    }

    public ImageButton(Image image, Dimension imageSize, int imageIndex, boolean alwaysInactive) {
        this.image = image;
        this.imageSize = imageSize;
        this.imageIndex = imageIndex;
        this.alwaysInactive = alwaysInactive;
        this.setDefaultValues();
        this.addMouseListener(this);
        this.dimRealSize = new Dimension(0, 0);
    }

    public ImageButton(String label, Image image, Dimension imageSize, int imageIndex) {
        this.label = label;
        this.image = image;
        this.imageSize = imageSize;
        this.imageIndex = imageIndex;
        this.setDefaultValues();
        this.addMouseListener(this);
        this.dimRealSize = new Dimension(0, 0);
    }

    private Image getGrayImage(Image image) {
        if (this.grayImage == null) {
            GrayFilter filter = new GrayFilter(this.darkness);
            FilteredImageSource producer = new FilteredImageSource(image.getSource(), filter);
            this.grayImage = this.createImage(producer);
        }
        return this.grayImage;
    }

    public void addActionListener(ActionListener l) {
        if (this.alisteners == null) {
            this.alisteners = new Vector();
        }
        this.alisteners.addElement(l);
    }

    public void removeActionListener(ActionListener l) {
        if (this.alisteners == null) {
            return;
        }
        this.alisteners.removeElement(l);
    }

    public void setImageIndex(int imageIndex) {
        this.imageIndex = imageIndex;
        this.repaint();
    }

    public void setDefaultValues() {
        this.colBg = SystemColor.control;
        this.colFg = SystemColor.controlText;
        this.colHlHl = SystemColor.controlLtHighlight;
        this.colHlNorm = SystemColor.controlHighlight;
        this.colShd = SystemColor.controlShadow;
        this.colHlShd = SystemColor.controlDkShadow;
        this.fontLabel = new Font("SansSerif", 0, 12);
        this.fontMetrics = this.getFontMetrics(this.fontLabel);
        if (this.image != null && this.label != null) {
            int itemWidth = this.fontMetrics.stringWidth(this.label) + this.fontMetrics.getAscent() + this.imageSize.width;
            int itemHeight = this.fontMetrics.getHeight() + this.fontMetrics.getLeading();
            if (itemHeight < this.imageSize.height) {
                itemHeight = this.imageSize.height;
            }
            this.dimSize = new Dimension(itemWidth, itemHeight);
        } else if (this.image != null) {
            this.dimSize = new Dimension(this.imageSize.width, this.imageSize.height);
        } else if (this.label != null) {
            this.dimSize = new Dimension(this.fontMetrics.stringWidth(this.label) + this.fontMetrics.getAscent(), this.fontMetrics.getHeight() + this.fontMetrics.getLeading());
        }
    }

    public void setEnabled(boolean state) {
        this.active = state;
        this.repaint();
    }

    public void addNotify() {
        super.addNotify();
    }

    public Dimension getPreferredSize() {
        return this.dimSize;
    }

    public Dimension getMinimumSize() {
        return this.dimSize;
    }

    public void update(Graphics g) {
        if (this.dimRealSize.width != this.getSize().width || this.dimRealSize.height != this.getSize().height) {
            this.offscreenImage = this.createImage(this.getSize().width, this.getSize().height);
            this.dimRealSize.setSize(this.getSize().width, this.getSize().height);
        }
        Graphics offscreenGraphics = this.offscreenImage.getGraphics();
        this.paint(offscreenGraphics);
        g.drawImage(this.offscreenImage, 0, 0, null);
    }

    public void paint(Graphics g) {
        int textX = 0;
        int textY = 0;
        int picX = 0;
        int picY = 0;
        g.setFont(this.fontLabel);
        g.setColor(this.colBg);
        g.fillRect(0, 0, this.getSize().width - 1, this.getSize().height - 1);
        switch (this.state) {
            case 0: {
                g.setColor(this.colHlNorm);
                break;
            }
            case 1: {
                g.setColor(this.colHlHl);
                break;
            }
            case 2: {
                g.setColor(this.colHlShd);
            }
        }
        g.drawLine(0, 0, this.getSize().width - 1, 0);
        g.drawLine(0, 0, 0, this.getSize().height - 1);
        switch (this.state) {
            case 0: {
                g.setColor(this.colShd);
                break;
            }
            case 1: {
                g.setColor(this.colHlShd);
                break;
            }
            case 2: {
                g.setColor(this.colHlHl);
            }
        }
        g.drawLine(this.getSize().width - 1, 0, this.getSize().width - 1, this.getSize().height - 1);
        g.drawLine(0, this.getSize().height - 1, this.getSize().width - 1, this.getSize().height - 1);
        g.setColor(this.active || this.alwaysInactive ? this.colFg : this.colShd);
        if (this.label != null && this.image != null) {
            int itemWidth = this.fontMetrics.stringWidth(this.label) + this.imageSize.width;
            int itemHeight = this.fontMetrics.getHeight() + this.fontMetrics.getAscent() + this.fontMetrics.getLeading();
            if (this.fontMetrics.getHeight() < this.imageSize.height) {
                itemHeight = this.imageSize.height;
            }
            picX = (this.getSize().width - itemWidth) / 2;
            picY = (this.getSize().height - itemHeight) / 2 + 1;
            textX = (this.getSize().width - itemWidth) / 2 + this.imageSize.width;
            textY = (this.getSize().height - this.fontMetrics.getHeight()) / 2 + this.fontMetrics.getAscent() + this.fontMetrics.getLeading() - 1;
            g.drawImage(this.active || this.alwaysInactive ? this.image : this.getGrayImage(this.image), picX, picY, picX + this.imageSize.width - 1, picY + this.imageSize.height - 1, this.imageIndex * this.imageSize.width, 0, (this.imageIndex + 1) * this.imageSize.width - 1, this.imageSize.height - 1, this);
            g.drawString(this.label, textX, textY);
        } else if (this.label != null) {
            textX = (this.getSize().width - this.fontMetrics.stringWidth(this.label)) / 2;
            textY = (this.getSize().height - this.fontMetrics.getHeight()) / 2 + this.fontMetrics.getAscent() + this.fontMetrics.getLeading() - 1;
            g.drawString(this.label, textX, textY);
        } else if (this.image != null) {
            picX = (this.getSize().width - this.imageSize.width) / 2;
            picY = (this.getSize().height - this.imageSize.height) / 2;
            g.drawImage(this.active || this.alwaysInactive ? this.image : this.getGrayImage(this.image), picX, picY, picX + this.imageSize.width - 1, picY + this.imageSize.height - 1, this.imageIndex * this.imageSize.width, 0, (this.imageIndex + 1) * this.imageSize.width - 1, this.imageSize.height - 1, this);
        }
    }

    public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
        if ((infoflags & 0x20) != 0) {
            this.repaint();
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mouseReleased(MouseEvent evt) {
        if (!this.active) {
            return;
        }
        this.state = 1;
        this.repaint();
        if (this.alisteners != null && !this.alisteners.isEmpty()) {
            ActionEvent event = new ActionEvent(this, 0, null);
            Vector vector = this.alisteners;
            synchronized (vector) {
                Enumeration e = this.alisteners.elements();
                while (e.hasMoreElements()) {
                    ActionListener l = (ActionListener)e.nextElement();
                    l.actionPerformed(event);
                }
            }
        }
    }

    public void mousePressed(MouseEvent evt) {
        if (!this.active) {
            return;
        }
        this.state = (byte)2;
        this.repaint();
    }

    public void mouseEntered(MouseEvent evt) {
        if (!this.active) {
            return;
        }
        this.state = 1;
        this.repaint();
    }

    public void mouseExited(MouseEvent evt) {
        if (!this.active) {
            return;
        }
        this.state = 0;
        this.repaint();
    }

    public void mouseMoved(MouseEvent evt) {
    }

    public void mouseDragged(MouseEvent evt) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mouseClicked(MouseEvent evt) {
        if (this.mlisteners != null && !this.mlisteners.isEmpty()) {
            Vector vector = this.mlisteners;
            synchronized (vector) {
                Enumeration e = this.mlisteners.elements();
                while (e.hasMoreElements()) {
                    MouseListener l = (MouseListener)e.nextElement();
                    l.mouseClicked(evt);
                }
            }
        }
    }

    class GrayFilter
    extends RGBImageFilter {
        private int darkness = -5263441;

        public GrayFilter() {
            this.canFilterIndexColorModel = true;
        }

        public GrayFilter(int darkness) {
            this();
            this.darkness = darkness;
        }

        public int filterRGB(int x, int y, int rgb) {
            return rgb & this.darkness;
        }
    }
}

