/*
 * Decompiled with CFR 0.152.
 */
package nn.pp.rc;

import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UTFDataFormatException;
import nn.pp.rc.MonitorData;
import nn.pp.rc.MonitoringStream;

public class MonitoringDataInputStream
extends FilterInputStream
implements MonitoringStream {
    private int countC;
    private int buflen = 65536;
    private int count = 0;
    private byte[] buf = new byte[this.buflen];
    private int pos = 0;

    public MonitoringDataInputStream(InputStream in) {
        super(in);
    }

    private final int readAByte() throws IOException {
        if (this.count - this.pos <= 0) {
            return this.in.read();
        }
        return this.buf[this.pos++] & 0xFF;
    }

    private final int readBytes(byte[] b, int off, int len) throws IOException {
        int avail = this.count - this.pos;
        if (avail <= 0) {
            return this.in.read(b, off, len);
        }
        int cnt = Math.min(len, avail);
        System.arraycopy(this.buf, this.pos, b, off, cnt);
        this.pos += cnt;
        return cnt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stall(byte[] b, int off, int bytes) {
        if (bytes == 0) {
            return;
        }
        MonitoringDataInputStream monitoringDataInputStream = this;
        synchronized (monitoringDataInputStream) {
            this.countC = this.countC - bytes > 0 ? (this.countC -= bytes) : 0;
        }
        int old_bytes = this.count - this.pos;
        if (old_bytes > 0) {
            if (old_bytes + bytes > this.buflen) {
                this.buflen = old_bytes + bytes;
                byte[] new_buf = new byte[this.buflen];
                System.arraycopy(this.buf, this.pos, new_buf, bytes, old_bytes);
                this.buf = new_buf;
            } else {
                System.arraycopy(this.buf, this.pos, this.buf, bytes, old_bytes);
            }
        }
        this.pos = 0;
        this.count = old_bytes + bytes;
        System.arraycopy(b, off, this.buf, this.pos, bytes);
    }

    public final int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int read(byte[] b, int off, int len) throws IOException {
        int ret = this.readBytes(b, off, len);
        MonitoringDataInputStream monitoringDataInputStream = this;
        synchronized (monitoringDataInputStream) {
            this.countC += ret;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int read() throws IOException {
        int b = this.readAByte();
        MonitoringDataInputStream monitoringDataInputStream = this;
        synchronized (monitoringDataInputStream) {
            ++this.countC;
        }
        return b;
    }

    public final void readFully(byte[] b) throws IOException {
        this.readFully(b, 0, b.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void readFully(byte[] b, int off, int len) throws IOException {
        int count;
        if (len < 0) {
            throw new IndexOutOfBoundsException();
        }
        InputStream in = this.in;
        for (int n = 0; n < len; n += count) {
            count = this.readBytes(b, off + n, len - n);
            if (count >= 0) continue;
            throw new EOFException();
        }
        MonitoringDataInputStream monitoringDataInputStream = this;
        synchronized (monitoringDataInputStream) {
            this.countC += len;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean readBoolean() throws IOException {
        int ch = this.readAByte();
        if (ch < 0) {
            throw new EOFException();
        }
        MonitoringDataInputStream monitoringDataInputStream = this;
        synchronized (monitoringDataInputStream) {
            ++this.countC;
        }
        return ch != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final byte readByte() throws IOException {
        int ch = this.readAByte();
        if (ch < 0) {
            throw new EOFException();
        }
        MonitoringDataInputStream monitoringDataInputStream = this;
        synchronized (monitoringDataInputStream) {
            ++this.countC;
        }
        return (byte)ch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int readUnsignedByte() throws IOException {
        int ch = this.readAByte();
        if (ch < 0) {
            throw new EOFException();
        }
        MonitoringDataInputStream monitoringDataInputStream = this;
        synchronized (monitoringDataInputStream) {
            ++this.countC;
        }
        return ch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final short readShort() throws IOException {
        int ch2;
        InputStream in = this.in;
        int ch1 = this.readAByte();
        if ((ch1 | (ch2 = this.readAByte())) < 0) {
            throw new EOFException();
        }
        MonitoringDataInputStream monitoringDataInputStream = this;
        synchronized (monitoringDataInputStream) {
            this.countC += 2;
        }
        return (short)((ch1 << 8) + (ch2 << 0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int readUnsignedShort() throws IOException {
        int ch2;
        InputStream in = this.in;
        int ch1 = this.readAByte();
        if ((ch1 | (ch2 = this.readAByte())) < 0) {
            throw new EOFException();
        }
        MonitoringDataInputStream monitoringDataInputStream = this;
        synchronized (monitoringDataInputStream) {
            this.countC += 2;
        }
        return (ch1 << 8) + (ch2 << 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final char readChar() throws IOException {
        int ch2;
        InputStream in = this.in;
        int ch1 = this.readAByte();
        if ((ch1 | (ch2 = this.readAByte())) < 0) {
            throw new EOFException();
        }
        MonitoringDataInputStream monitoringDataInputStream = this;
        synchronized (monitoringDataInputStream) {
            this.countC += 2;
        }
        return (char)((ch1 << 8) + (ch2 << 0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int readInt() throws IOException {
        int ch4;
        int ch3;
        int ch2;
        InputStream in = this.in;
        int ch1 = this.readAByte();
        if ((ch1 | (ch2 = this.readAByte()) | (ch3 = this.readAByte()) | (ch4 = this.readAByte())) < 0) {
            throw new EOFException();
        }
        MonitoringDataInputStream monitoringDataInputStream = this;
        synchronized (monitoringDataInputStream) {
            this.countC += 4;
        }
        return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + (ch4 << 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long readUnsignedInt() throws IOException {
        long ch4;
        long ch3;
        long ch2;
        InputStream in = this.in;
        long ch1 = this.readAByte();
        if ((ch1 | (ch2 = (long)this.readAByte()) | (ch3 = (long)this.readAByte()) | (ch4 = (long)this.readAByte())) < 0L) {
            throw new EOFException();
        }
        MonitoringDataInputStream monitoringDataInputStream = this;
        synchronized (monitoringDataInputStream) {
            this.countC += 4;
        }
        return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + (ch4 << 0);
    }

    public final String readUTF() throws IOException {
        int utflen = this.readUnsignedShort();
        StringBuffer str = new StringBuffer(utflen);
        byte[] bytearr = new byte[utflen];
        int count = 0;
        this.readFully(bytearr, 0, utflen);
        block5: while (count < utflen) {
            int c = bytearr[count] & 0xFF;
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++count;
                    str.append((char)c);
                    continue block5;
                }
                case 12: 
                case 13: {
                    if ((count += 2) > utflen) {
                        throw new UTFDataFormatException();
                    }
                    byte char2 = bytearr[count - 1];
                    if ((char2 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    str.append((char)((c & 0x1F) << 6 | char2 & 0x3F));
                    continue block5;
                }
                case 14: {
                    if ((count += 3) > utflen) {
                        throw new UTFDataFormatException();
                    }
                    byte char2 = bytearr[count - 2];
                    byte char3 = bytearr[count - 1];
                    if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    str.append((char)((c & 0xF) << 12 | (char2 & 0x3F) << 6 | (char3 & 0x3F) << 0));
                    continue block5;
                }
            }
            throw new UTFDataFormatException();
        }
        return new String(str);
    }

    public final synchronized MonitorData getAndClearIn() {
        MonitorData ret = new MonitorData(this.countC);
        this.countC = 0;
        return ret;
    }

    public final synchronized int getAndClearOut() {
        return 0;
    }

    public final synchronized void increaseCounters(int value) {
        this.countC += value;
    }
}

