/*
 * Decompiled with CFR 0.152.
 */
package nn.pp.rc.test;

import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

class FixedGlassPane
extends JPanel
implements MouseListener,
MouseMotionListener,
FocusListener {
    Toolkit toolkit = Toolkit.getDefaultToolkit();
    JMenuBar menuBar;
    Container contentPane;
    boolean inDrag = false;
    boolean needToRedispatch = false;

    public FixedGlassPane(JMenuBar mb, Container cp) {
        this.menuBar = mb;
        this.contentPane = cp;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addFocusListener(this);
    }

    public void setVisible(boolean v) {
        if (v) {
            this.requestFocus();
        }
        super.setVisible(v);
    }

    public void focusLost(FocusEvent fe) {
        if (this.isVisible()) {
            this.requestFocus();
        }
    }

    public void focusGained(FocusEvent fe) {
    }

    public void setNeedToRedispatch(boolean need) {
        this.needToRedispatch = need;
    }

    public void mouseDragged(MouseEvent e) {
        if (this.needToRedispatch) {
            this.redispatchMouseEvent(e);
        }
    }

    public void mouseMoved(MouseEvent e) {
        if (this.needToRedispatch) {
            this.redispatchMouseEvent(e);
        }
    }

    public void mouseClicked(MouseEvent e) {
        if (this.needToRedispatch) {
            this.redispatchMouseEvent(e);
        }
    }

    public void mouseEntered(MouseEvent e) {
        if (this.needToRedispatch) {
            this.redispatchMouseEvent(e);
        }
    }

    public void mouseExited(MouseEvent e) {
        if (this.needToRedispatch) {
            this.redispatchMouseEvent(e);
        }
    }

    public void mousePressed(MouseEvent e) {
        if (this.needToRedispatch) {
            this.redispatchMouseEvent(e);
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (this.needToRedispatch) {
            this.redispatchMouseEvent(e);
            this.inDrag = false;
        }
    }

    private void redispatchMouseEvent(MouseEvent e) {
        boolean inButton = false;
        boolean inMenuBar = false;
        Point glassPanePoint = e.getPoint();
        Component component = null;
        Container container = this.contentPane;
        Point containerPoint = SwingUtilities.convertPoint(this, glassPanePoint, this.contentPane);
        int eventID = e.getID();
        if (containerPoint.y < 0) {
            inMenuBar = true;
            container = this.menuBar;
            containerPoint = SwingUtilities.convertPoint(this, glassPanePoint, this.menuBar);
            this.testForDrag(eventID);
        }
        if ((component = SwingUtilities.getDeepestComponentAt(container, containerPoint.x, containerPoint.y)) == null) {
            return;
        }
        inButton = true;
        this.testForDrag(eventID);
        if (inMenuBar || inButton || this.inDrag) {
            Point componentPoint = SwingUtilities.convertPoint(this, glassPanePoint, component);
            component.dispatchEvent(new MouseEvent(component, eventID, e.getWhen(), e.getModifiers(), componentPoint.x, componentPoint.y, e.getClickCount(), e.isPopupTrigger()));
        }
    }

    private void testForDrag(int eventID) {
        if (eventID == 501) {
            this.inDrag = true;
        }
    }
}

